/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionsxml;

import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class SessionsXMLSchemaProjectXMLTest
extends AutoVerifyTestCase {
    DatabaseSession employeeSession;

    public SessionsXMLSchemaProjectXMLTest() {
        this.setDescription("Test sessions XML schema with project xml");
    }

    public void reset() {
        if (this.employeeSession != null && this.employeeSession.isConnected()) {
            this.employeeSession.logout();
            SessionManager.getManager().getSessions().remove(this.employeeSession);
            this.employeeSession = null;
        }
    }

    public void test() {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader("org/eclipse/persistence/testing/models/sessionsxml/XMLSchemaWithProjectXML.xml");
        this.employeeSession = (DatabaseSession)SessionManager.getManager().getSession(loader, "EmployeeSession", ((Object)((Object)this)).getClass().getClassLoader(), true, true);
    }

    protected void verify() {
        if (this.employeeSession == null) {
            throw new TestErrorException("Employee session is null");
        }
        if (this.employeeSession.getDescriptor(Employee.class) == null) {
            throw new TestErrorException("Missing a descriptor from the Employee project");
        }
        if (!this.employeeSession.isConnected()) {
            throw new TestErrorException("Employee session is connected");
        }
    }
}

