/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.relationshipmaintenance;

import java.util.Vector;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.relationshipmaintenance.FieldOffice;
import org.eclipse.persistence.testing.models.relationshipmaintenance.SalesPerson;

public class SetToNullTest
extends AutoVerifyTestCase {
    public FieldOffice fieldOfficeClone;
    public SalesPerson sales = null;

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.beginTransaction();
    }

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Vector salesPeople = uow.readAllObjects(SalesPerson.class);
        for (SalesPerson this.sales : salesPeople) {
            if (this.sales.getFieldOffice() == null) continue;
            this.fieldOfficeClone = this.sales.getFieldOffice();
            this.sales.setFieldOffice(null);
            uow.commit();
            return;
        }
        throw new TestErrorException("Test failed to run correctly as there are no sales people associated with a field office in the cache");
    }

    public void verify() {
        if (this.fieldOfficeClone.getSalespeople().contains(this.sales) || this.sales.getFieldOffice() != null) {
            throw new TestErrorException("Failed to set the backPointer information");
        }
    }
}

