/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.optimization;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.insurance.Policy;
import org.eclipse.persistence.testing.models.insurance.PolicyHolder;

public class NestedBatchReadingTest
extends TestCase {
    public Vector result;
    BatchFetchType batchType;

    public NestedBatchReadingTest(BatchFetchType batchType) {
        this.setDescription("Tests batch reading nesting across two 1-m mappings, polcies and claims");
        this.batchType = batchType;
        this.setName(this.getName() + batchType);
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        ReadAllQuery query = new ReadAllQuery();
        query.setBatchFetchType(this.batchType);
        query.setReferenceClass(PolicyHolder.class);
        query.addBatchReadAttribute("policies");
        query.addBatchReadAttribute(query.getExpressionBuilder().get("policies").get("claims"));
        this.result = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
    }

    public void verify() {
        boolean foundClaims = false;
        Enumeration holdersEnum = this.result.elements();
        while (holdersEnum.hasMoreElements()) {
            Enumeration policiesEnum = ((PolicyHolder)holdersEnum.nextElement()).getPolicies().elements();
            while (policiesEnum.hasMoreElements()) {
                if (((Policy)policiesEnum.nextElement()).getClaims().isEmpty()) continue;
                foundClaims = true;
            }
        }
        if (!foundClaims) {
            throw new TestErrorException("claims were not bacthed correctly.");
        }
    }
}

