/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class QueryCacheTest
extends TestCase {
    protected ReadAllQuery query = null;
    protected Vector initialResults = null;
    protected Vector secondResults = null;

    public QueryCacheTest() {
        this.setDescription("Ensure the results of a cached query are correct.");
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.query = new ReadAllQuery(Employee.class);
        this.query.cacheQueryResults();
        ExpressionBuilder employees = new ExpressionBuilder();
        Expression exp = employees.get("firstName").like(employees.getParameter("name"));
        this.query.setSelectionCriteria(exp);
        this.query.addArgument("name");
    }

    public void test() {
        Vector<String> arguments = new Vector<String>();
        arguments.add("J%");
        this.initialResults = (Vector)this.getSession().executeQuery((DatabaseQuery)this.query, arguments);
        this.secondResults = (Vector)this.getSession().executeQuery((DatabaseQuery)this.query, arguments);
    }

    public void verify() {
        if (this.initialResults.size() != 3 || this.secondResults.size() != 3) {
            throw new TestErrorException("The results sizes do not match.");
        }
        Iterator i1 = this.initialResults.iterator();
        Iterator i2 = this.secondResults.iterator();
        while (i1.hasNext()) {
            Employee emp = (Employee)i1.next();
            if (!emp.getFirstName().startsWith("J")) {
                throw new TestErrorException("An incorrect employee was returned.");
            }
            if (emp.equals(i2.next())) continue;
            throw new TestErrorException("The cached query did not return the same result as the original query.");
        }
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }
}

