/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.tests.queries.NoIdentityMapProject;
import org.eclipse.persistence.testing.tests.queries.TestClass1;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;

public class IdentitySystem
extends TestSystem {
    public IdentitySystem() {
        this.project = new NoIdentityMapProject();
    }

    public void addDescriptors(DatabaseSession session) {
        if (this.project == null) {
            this.project = new NoIdentityMapProject();
        }
        session.addDescriptors(this.project);
    }

    public TestClass1 basicIdentityExample1() {
        TestClass1 example = new TestClass1();
        example.setTest1("Lauretta");
        example.setTest2("Cole");
        return example;
    }

    public TestClass1 basicIdentityExample2() {
        TestClass1 example = new TestClass1();
        example.setTest1("William");
        example.setTest2("George");
        return example;
    }

    public TestClass1 basicIdentityExample3() {
        TestClass1 example = new TestClass1();
        example.setTest1("Victoria");
        example.setTest2("Sawyerr");
        return example;
    }

    public void buildExamples() {
        this.testIdentityExample1();
        this.testIdentityExample2();
        this.testIdentityExample3();
    }

    private boolean containsObject(Class domainClass, String identifier) {
        PopulationManager populationManager = PopulationManager.getDefaultManager();
        return populationManager.containsObject(domainClass, identifier);
    }

    public void createTables(DatabaseSession session) {
        SchemaManager schemaManager = new SchemaManager(session);
        schemaManager.replaceObject((DatabaseObjectDefinition)TestClass1.tableDefinition());
        schemaManager.createSequences();
    }

    private Object getObject(Class domainClass, String identifier) {
        PopulationManager populationManager = PopulationManager.getDefaultManager();
        return populationManager.getObject(domainClass, identifier);
    }

    public DatabaseSession login() {
        DatabaseSession session = this.project.createDatabaseSession();
        session.login();
        return session;
    }

    public void populate(DatabaseSession session) {
        IdentitySystem system = new IdentitySystem();
        UnitOfWork unitOfWork = session.acquireUnitOfWork();
        system.buildExamples();
        Vector allObjects = new Vector();
        PopulationManager.getDefaultManager().addAllObjectsForClass(TestClass1.class, allObjects);
        unitOfWork.registerAllObjects(allObjects);
        unitOfWork.commit();
    }

    private void registerObject(Object domainObject, String identifier) {
        PopulationManager populationManager = PopulationManager.getDefaultManager();
        populationManager.registerObject(domainObject, identifier);
    }

    public TestClass1 testIdentityExample1() {
        TestClass1 example = this.basicIdentityExample1();
        this.registerObject(example, "100");
        return example;
    }

    public TestClass1 testIdentityExample2() {
        TestClass1 example = this.basicIdentityExample2();
        this.registerObject(example, "200");
        return example;
    }

    public TestClass1 testIdentityExample3() {
        TestClass1 example = this.basicIdentityExample3();
        this.registerObject(example, "300");
        return example;
    }
}

