/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.proxyindirection;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.proxyindirection.Cubicle;
import org.eclipse.persistence.testing.tests.proxyindirection.Employee;

public class DeleteTest
extends AutoVerifyTestCase {
    public DeleteTest() {
        this.setDescription("Tests deleting with private ownership with Proxy Indirection.");
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        Cubicle cube = (Cubicle)this.getSession().readObject(Cubicle.class, new ExpressionBuilder().get("employee").get("firstName").equal((Object)"Rick"));
        this.getAbstractSession().deleteObject((Object)cube);
    }

    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Employee emp = (Employee)this.getSession().readObject(Employee.class, new ExpressionBuilder().get("firstName").equal((Object)"Rick"));
        if (emp != null) {
            throw new TestErrorException("Employee was not deleted along with Cubicle.");
        }
    }
}

