/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.reading;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;

public class ReadObjectStaticvsDynamicTest
extends PerformanceComparisonTestCase {
    protected static int ITERATIONS = 20;
    protected Employee employee;

    public ReadObjectStaticvsDynamicTest() {
        this.setName("ReadObjectStaticvsDynamicTest");
        this.setDescription("Compares the performance between having a static (cached SQL) read-object-query and not.");
        this.addStaticReadObjectTest();
        this.addParameterizedDynamicReadObjectTest();
        this.addParameterizedReadObjectTest();
    }

    public void setup() {
        Expression expression = new ExpressionBuilder().get("firstName").equal((Object)"Bob");
        this.employee = (Employee)this.getSession().readObject(Employee.class, expression);
    }

    public void test() throws Exception {
        ReadObjectQuery query = this.getSession().getDescriptor(Employee.class).getQueryManager().getReadObjectQuery();
        this.getSession().getDescriptor(Employee.class).getQueryManager().setReadObjectQuery(null);
        if (query == null) {
            throw new TestErrorException("Query not static");
        }
        for (int index = 0; index < ITERATIONS; ++index) {
            this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
            this.getSession().readObject((Object)this.employee);
        }
        this.getSession().getDescriptor(Employee.class).getQueryManager().setReadObjectQuery(query);
    }

    public void addStaticReadObjectTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                for (int index = 0; index < ITERATIONS; ++index) {
                    this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
                    this.getSession().readObject((Object)ReadObjectStaticvsDynamicTest.this.employee);
                }
            }
        };
        test.setName("StaticReadObjectTest");
        test.setAllowableDecrease(5.0);
        this.addTest((TestCase)test);
    }

    public void addParameterizedDynamicReadObjectTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                ReadObjectQuery readQuery = this.getSession().getDescriptor(Employee.class).getQueryManager().getReadObjectQuery();
                this.getSession().getDescriptor(Employee.class).getQueryManager().setReadObjectQuery(null);
                for (int index = 0; index < ITERATIONS; ++index) {
                    this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
                    ReadObjectQuery query = new ReadObjectQuery(Employee.class);
                    query.setSelectionObject((Object)ReadObjectStaticvsDynamicTest.this.employee);
                    query.bindAllParameters();
                    query.cacheStatement();
                    this.getSession().executeQuery((DatabaseQuery)query);
                }
                this.getSession().getDescriptor(Employee.class).getQueryManager().setReadObjectQuery(readQuery);
            }
        };
        test.setName("ParameterizedDynamicReadObjectTest");
        test.setAllowableDecrease(20.0);
        this.addTest((TestCase)test);
    }

    public void addParameterizedReadObjectTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                ReadObjectQuery readQuery = this.getSession().getDescriptor(Employee.class).getQueryManager().getReadObjectQuery();
                readQuery.cacheStatement();
                for (int index = 0; index < ITERATIONS; ++index) {
                    this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
                    ReadObjectQuery query = new ReadObjectQuery(Employee.class);
                    query.setSelectionObject((Object)ReadObjectStaticvsDynamicTest.this.employee);
                    this.getSession().executeQuery((DatabaseQuery)query);
                }
                readQuery.dontCacheStatement();
            }
        };
        test.setName("ParameterizedReadObjectTest");
        test.setAllowableDecrease(20.0);
        this.addTest((TestCase)test);
    }
}

