/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.reading;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;

public class ReadAllvsBatch21mTest
extends PerformanceComparisonTestCase {
    public ReadAllvsBatch21mTest() {
        this.setDescription("This test compares the performance of read all and access to 2 1-m vs batching and joining.");
        this.addReadAllBatchTest();
        this.addReadAllJoinTest();
    }

    public void test() throws Exception {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Vector results = this.getSession().readAllObjects(Employee.class);
        for (int index = 0; index < results.size(); ++index) {
            Employee employee = (Employee)results.get(index);
            employee.getPhoneNumbers().size();
            employee.getManagedEmployees().size();
        }
    }

    public void addReadAllBatchTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
                ReadAllQuery query = new ReadAllQuery(Employee.class);
                query.addBatchReadAttribute("phoneNumbers");
                query.addBatchReadAttribute("managedEmployees");
                List results = (List)this.getSession().executeQuery((DatabaseQuery)query);
                for (int index = 0; index < results.size(); ++index) {
                    Employee employee = (Employee)results.get(index);
                    employee.getPhoneNumbers().size();
                    employee.getManagedEmployees().size();
                }
            }
        };
        test.setName("ReadAllBatchTest");
        test.setAllowableDecrease(500.0);
        this.addTest((TestCase)test);
    }

    public void addReadAllJoinTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
                ReadAllQuery query = new ReadAllQuery(Employee.class);
                query.addJoinedAttribute(query.getExpressionBuilder().anyOf("phoneNumbers"));
                query.addJoinedAttribute(query.getExpressionBuilder().anyOfAllowingNone("managedEmployees"));
                List results = (List)this.getSession().executeQuery((DatabaseQuery)query);
                for (int index = 0; index < results.size(); ++index) {
                    Employee employee = (Employee)results.get(index);
                    employee.getPhoneNumbers().size();
                    employee.getManagedEmployees().size();
                }
            }
        };
        test.setName("ReadAllJoinTest");
        test.setAllowableDecrease(200.0);
        this.addTest((TestCase)test);
    }
}

