/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.reading;

import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;

public class ReadAllFirstResultVsRownumFilteringTest
extends PerformanceComparisonTestCase {
    int size;

    public ReadAllFirstResultVsRownumFilteringTest() {
        this.setDescription("This test compares the performance of Oracle pagination vs non pagination.");
        this.addReadAllRownumFilteringTest();
        this.addReadAllFirstResultTest();
    }

    public void setup() throws Throwable {
        super.setup();
        this.size = this.getSession().readAllObjects(Employee.class).size();
    }

    public void test() throws Exception {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        this.getSession().executeQuery((DatabaseQuery)query);
    }

    public void addReadAllRownumFilteringTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                ReadAllQuery query = new ReadAllQuery(Employee.class);
                query.setFirstResult(ReadAllFirstResultVsRownumFilteringTest.this.size - 1);
                this.getSession().executeQuery((DatabaseQuery)query);
            }
        };
        test.setName("ReadAllRownumFilteringTest");
        test.setAllowableDecrease(350.0);
        this.addTest((TestCase)test);
    }

    public void addReadAllFirstResultTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                ReadAllQuery query = new ReadAllQuery(Employee.class);
                query.setFirstResult(ReadAllFirstResultVsRownumFilteringTest.this.size - 1);
                this.getSession().executeQuery((DatabaseQuery)query);
            }

            public void startTest() {
                ((OraclePlatform)this.getSession().getPlatform()).setShouldUseRownumFiltering(false);
            }

            public void endTest() {
                ((OraclePlatform)this.getSession().getPlatform()).setShouldUseRownumFiltering(true);
            }
        };
        test.setName("FirstResultTest");
        this.addTest((TestCase)test);
    }
}

