/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.mapping;

import java.util.Calendar;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.mapping.Computer;
import org.eclipse.persistence.testing.models.mapping.Employee;
import org.eclipse.persistence.testing.models.mapping.JobDescription;
import org.eclipse.persistence.testing.models.mapping.Phone;

public class UnitOfWorkCommitResumeTest
extends WriteObjectTest {
    public Object unitOfWorkWorkingCopy;
    public UnitOfWork unitOfWork;

    public UnitOfWorkCommitResumeTest() {
    }

    public UnitOfWorkCommitResumeTest(Object originalObject) {
        super(originalObject);
    }

    protected void changeUnitOfWorkWorkingCopy() {
        Employee employee = (Employee)this.unitOfWorkWorkingCopy;
        employee.setJobDescription(JobDescription.example3());
        Calendar aCalendar = Calendar.getInstance();
        aCalendar.set(1978, 11, 31, 23, 59, 59);
        aCalendar.set(14, 0);
        employee.dateAndTimeOfBirth = aCalendar.getTime();
        aCalendar.set(1995, 3, 14, 9, 0, 23);
        employee.joiningDate = aCalendar.getTime();
        Vector thePolicies = employee.getPolicies();
        thePolicies.removeElementAt(0);
        thePolicies.addElement("a silly policy");
        Computer aComputer = (Computer)employee.getComputer();
        if (aComputer.isMacintosh.booleanValue()) {
            aComputer.notMacintosh();
        } else {
            aComputer.isMacintosh();
        }
        Vector thePhoneNumbers = employee.getPhoneNumbers();
        thePhoneNumbers.removeElementAt(0);
        thePhoneNumbers.addElement(Phone.example10());
        thePhoneNumbers.addElement(Phone.example11());
        thePhoneNumbers.addElement(Phone.example12());
        thePhoneNumbers.addElement(Phone.example13());
        thePhoneNumbers.addElement(Phone.example14());
        thePhoneNumbers.removeElementAt(0);
    }

    protected void changeUnitOfWorkWorkingCopyAgain() {
        Employee employee = (Employee)this.unitOfWorkWorkingCopy;
        JobDescription aJobDescription = employee.getJobDescription();
        aJobDescription.setDescription("Serve customers ice cream");
        Calendar aCalendar = Calendar.getInstance();
        aCalendar.set(14, 0);
        aCalendar.set(2000, 1, 28, 15, 45, 0);
        aJobDescription.setEndDate(aCalendar.getTime());
        aJobDescription.setSalary(10000.0f);
        aJobDescription.setTitle("Ice cream stand attendant");
        aCalendar.set(1977, 11, 31, 23, 59, 59);
        employee.dateAndTimeOfBirth = aCalendar.getTime();
        aCalendar.set(1994, 9, 19, 9, 0, 23);
        employee.joiningDate = aCalendar.getTime();
        employee.setPolicies(new Vector());
        Vector thePhoneNumbers = employee.getPhoneNumbers();
        thePhoneNumbers.addElement(Phone.example1());
        thePhoneNumbers.addElement(Phone.example2());
        thePhoneNumbers.addElement(Phone.example3());
        thePhoneNumbers.addElement(Phone.example4());
        thePhoneNumbers.removeElementAt(0);
        thePhoneNumbers.removeElementAt(0);
        thePhoneNumbers.removeElementAt(0);
        thePhoneNumbers.removeElementAt(0);
    }

    protected void setup() {
        super.setup();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
        this.unitOfWorkWorkingCopy = this.unitOfWork.registerObject(this.objectToBeWritten);
        this.changeUnitOfWorkWorkingCopy();
        if (!this.compareObjects(this.originalObject, this.objectToBeWritten)) {
            throw new TestErrorException("The original object was changed through changing the clone.");
        }
    }

    protected void test() {
        this.unitOfWork.commitAndResume();
        this.changeUnitOfWorkWorkingCopyAgain();
        this.unitOfWork.commitAndResume();
    }

    protected void verify() {
        try {
            if (!this.compareObjects(this.unitOfWorkWorkingCopy, this.objectToBeWritten)) {
                throw new TestErrorException("The object in the unit of work has not been commited properly to its parent");
            }
        }
        catch (DatabaseException exception) {
            if (this.getSession().getLogin().getPlatform().isDBase()) {
                throw new TestWarningException("This fails because of some strange bug in the DBase driver. " + exception.getMessage());
            }
            throw exception;
        }
        super.verify();
    }
}

