/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.junit.transparentindirection;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.stream.StreamSupport;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.indirection.IndirectCollectionsFactory;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.testing.tests.junit.transparentindirection.TestSession;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IndirectListTest {
    private Vector<String> list;
    private IndirectList<String> testList;
    private Listener testListLsn;
    private Class<? extends IndirectList> cls;
    private boolean useListener;

    @Parameterized.Parameters(name="{0}, {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({IndirectList.class, true}, {IndirectList.class, false}, {L.class, true}, {L.class, false});
    }

    public IndirectListTest(Class<? extends IndirectList> cls, boolean useListener) {
        this.cls = cls;
        this.useListener = useListener;
    }

    @Before
    public void setUp() {
        this.list = this.setUpList();
        Vector<String> temp = new Vector<String>(this.list);
        QueryBasedValueHolder vh = new QueryBasedValueHolder((ReadQuery)new ReadAllQuery(), (AbstractRecord)new DatabaseRecord(), (AbstractSession)new TestSession(temp));
        if (this.cls == null) {
            this.testList = IndirectCollectionsFactory.createIndirectList();
        } else {
            try {
                this.testList = this.cls.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        this.testList.setValueHolder((ValueHolderInterface)vh);
        if (this.useListener) {
            this.testListLsn = new Listener();
            this.testList._persistence_setPropertyChangeListener((PropertyChangeListener)this.testListLsn);
        }
    }

    protected Vector setUpList() {
        Vector<String> result = new Vector<String>();
        result.addElement("zero");
        result.addElement("one");
        result.addElement("two");
        result.addElement("three");
        result.addElement("four");
        result.addElement("five");
        result.addElement("six");
        result.addElement("seven");
        result.addElement("eight");
        result.addElement("nine");
        return result;
    }

    @After
    public void tearDown() {
        if (this.useListener) {
            this.testListLsn.events.clear();
        }
    }

    @Test
    public void testAdd1() {
        String temp = "foo";
        this.list.add(3, temp);
        this.testList.add(3, (Object)temp);
        Assert.assertEquals(this.list, this.testList);
        Assert.assertTrue((boolean)this.testList.contains((Object)temp));
        this.assertAddEvents(1);
    }

    @Test
    public void testAdd2() {
        String temp = "foo";
        this.list.add(temp);
        this.testList.add((Object)temp);
        Assert.assertEquals(this.list, this.testList);
        Assert.assertTrue((boolean)this.testList.contains((Object)temp));
        this.assertAddEvents(1);
    }

    @Test
    public void testAddAll1() {
        Vector<String> temp = new Vector<String>();
        temp.addElement("foo");
        temp.addElement("bar");
        this.list.addAll(temp);
        this.testList.addAll(temp);
        Assert.assertEquals(this.list, this.testList);
        Assert.assertTrue((boolean)this.testList.containsAll(temp));
        this.assertAddEvents(2);
    }

    @Test
    public void testAddAll2() {
        Vector<String> temp = new Vector<String>();
        temp.addElement("foo");
        temp.addElement("bar");
        this.list.addAll(3, temp);
        this.testList.addAll(3, temp);
        Assert.assertEquals(this.list, this.testList);
        Assert.assertTrue((boolean)this.testList.containsAll(temp));
        this.assertAddEvents(2);
    }

    @Test
    public void testAddElement() {
        String temp = "foo";
        this.list.addElement(temp);
        this.testList.addElement((Object)temp);
        Assert.assertEquals(this.list, this.testList);
        Assert.assertTrue((boolean)this.testList.contains((Object)temp));
        this.assertAddEvents(1);
    }

    @Test
    public void testClear() {
        int originalSize = this.testList.size();
        this.list.clear();
        this.testList.clear();
        Assert.assertEquals(this.list, this.testList);
        Assert.assertTrue((boolean)this.testList.isEmpty());
        this.assertRemoveEvents(originalSize);
    }

    @Test
    public void testContains() {
        Assert.assertTrue((boolean)this.testList.contains((Object)this.list.elementAt(1)));
        this.assertNoEvents();
    }

    @Test
    public void testContainsAll() {
        Assert.assertTrue((boolean)this.testList.containsAll(this.list.subList(1, 5)));
        this.assertNoEvents();
    }

    @Test
    public void testElementAt() {
        Assert.assertEquals((Object)this.list.elementAt(1), (Object)this.testList.elementAt(1));
        this.assertNoEvents();
    }

    @Test
    public void testElements() {
        Assert.assertEquals((Object)this.list.elements().nextElement(), this.testList.elements().nextElement());
        this.assertNoEvents();
    }

    @Test
    public void testEquals() {
        Assert.assertTrue((boolean)this.testList.equals(this.list));
        this.assertNoEvents();
    }

    @Test
    public void testFirstElement() {
        Assert.assertEquals((Object)this.list.firstElement(), (Object)this.testList.firstElement());
        this.assertNoEvents();
    }

    @Test
    public void testGet() {
        Assert.assertEquals((Object)this.list.get(1), (Object)this.testList.get(1));
        this.assertNoEvents();
    }

    @Test
    public void testHashCode() {
        Assert.assertEquals((long)this.list.hashCode(), (long)this.testList.hashCode());
        this.assertNoEvents();
    }

    @Test
    public void testIndexOf1() {
        String temp = "one";
        Assert.assertEquals((long)this.list.indexOf(temp), (long)this.testList.indexOf((Object)temp));
        this.assertNoEvents();
    }

    @Test
    public void testIndexOf2() {
        String temp = "seven";
        Assert.assertEquals((long)this.list.indexOf(temp, 3), (long)this.testList.indexOf((Object)temp, 3));
        this.assertNoEvents();
    }

    @Test
    public void testInsertElementAt() {
        String temp = "foo";
        this.list.insertElementAt(temp, 3);
        this.testList.insertElementAt((Object)temp, 3);
        Assert.assertEquals(this.list, this.testList);
        Assert.assertTrue((boolean)this.testList.contains((Object)temp));
        this.assertAddEvents(1);
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((!this.testList.isEmpty() ? 1 : 0) != 0);
        this.assertNoEvents();
    }

    @Test
    public void testIterator() {
        int i = 0;
        Iterator stream = this.testList.iterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        Assert.assertEquals((long)this.list.size(), (long)i);
        this.assertNoEvents();
    }

    @Test
    public void testLastElement() {
        Assert.assertEquals((Object)this.list.lastElement(), (Object)this.testList.lastElement());
        this.assertNoEvents();
    }

    @Test
    public void testLastIndexOf1() {
        String temp = "one";
        Assert.assertEquals((long)this.list.lastIndexOf(temp), (long)this.testList.lastIndexOf((Object)temp));
        this.assertNoEvents();
    }

    @Test
    public void testLastIndexOf2() {
        String temp = "one";
        Assert.assertEquals((long)this.list.lastIndexOf(temp, 7), (long)this.testList.lastIndexOf((Object)temp, 7));
        this.assertNoEvents();
    }

    @Test
    public void testListIterator1() {
        int i = 0;
        ListIterator stream = this.testList.listIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        Assert.assertEquals((long)this.list.size(), (long)i);
        this.assertNoEvents();
    }

    @Test
    public void testListIterator2() {
        int i = 0;
        ListIterator stream = this.testList.listIterator(2);
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        Assert.assertEquals((long)this.list.size(), (long)(i + 2));
        this.assertNoEvents();
    }

    @Test
    public void testRemove1() {
        String temp = this.list.remove(1);
        Assert.assertEquals((Object)temp, (Object)this.testList.remove(1));
        Assert.assertEquals(this.list, this.testList);
        Assert.assertTrue((!this.testList.contains((Object)temp) ? 1 : 0) != 0);
        this.assertRemoveEvents(1);
    }

    @Test
    public void testRemove2() {
        String temp = "one";
        Assert.assertTrue((boolean)this.list.remove(temp));
        Assert.assertTrue((boolean)this.testList.remove((Object)temp));
        Assert.assertEquals(this.list, this.testList);
        Assert.assertTrue((!this.testList.contains((Object)temp) ? 1 : 0) != 0);
        this.assertRemoveEvents(1);
    }

    @Test
    public void testRemoveAll() {
        Vector<String> temp = new Vector<String>();
        temp.addElement("one");
        temp.addElement("two");
        Assert.assertTrue((boolean)this.list.removeAll(temp));
        Assert.assertTrue((boolean)this.testList.removeAll(temp));
        Assert.assertEquals(this.list, this.testList);
        Assert.assertTrue((!this.testList.containsAll(temp) ? 1 : 0) != 0);
        this.assertRemoveEvents(2);
    }

    @Test
    public void testRemoveAllElements() {
        int originalSize = this.testList.size();
        this.list.removeAllElements();
        this.testList.removeAllElements();
        Assert.assertEquals(this.list, this.testList);
        Assert.assertTrue((this.testList.size() == 0 ? 1 : 0) != 0);
        this.assertRemoveEvents(originalSize);
    }

    @Test
    public void testRemoveElement() {
        String temp = "one";
        Assert.assertTrue((boolean)this.list.removeElement(temp));
        Assert.assertTrue((boolean)this.testList.removeElement((Object)temp));
        Assert.assertEquals(this.list, this.testList);
        Assert.assertTrue((!this.testList.contains((Object)temp) ? 1 : 0) != 0);
        this.assertRemoveEvents(1);
    }

    @Test
    public void testRemoveElementAt() {
        Object temp = this.testList.elementAt(1);
        this.list.removeElementAt(1);
        this.testList.removeElementAt(1);
        Assert.assertEquals(this.list, this.testList);
        Assert.assertTrue((!this.testList.contains(temp) ? 1 : 0) != 0);
        this.assertRemoveEvents(1);
    }

    @Test
    public void testRetainAll() {
        int originalSize = this.testList.size();
        Vector<String> temp = new Vector<String>();
        temp.addElement("one");
        temp.addElement("two");
        Assert.assertTrue((boolean)this.list.retainAll(temp));
        Assert.assertTrue((boolean)this.testList.retainAll(temp));
        Assert.assertEquals(this.list, this.testList);
        Assert.assertTrue((boolean)this.testList.containsAll(temp));
        Assert.assertEquals((long)temp.size(), (long)this.testList.size());
        this.assertRemoveEvents(originalSize - temp.size());
    }

    @Test
    public void testSet() {
        String temp = "foo";
        this.list.set(3, temp);
        this.testList.set(3, (Object)temp);
        Assert.assertEquals(this.list, this.testList);
        Assert.assertTrue((boolean)this.testList.contains((Object)temp));
        this.assertRemoveAddEvents(1);
    }

    @Test
    public void testSetElementAt() {
        String temp = "foo";
        this.list.setElementAt(temp, 3);
        this.testList.setElementAt((Object)temp, 3);
        Assert.assertEquals(this.list, this.testList);
        Assert.assertTrue((boolean)this.testList.contains((Object)temp));
        this.assertRemoveAddEvents(1);
    }

    @Test
    public void testSize() {
        Assert.assertEquals((long)this.list.size(), (long)this.testList.size());
        this.assertNoEvents();
    }

    @Test
    public void testSubList() {
        Assert.assertEquals(this.list.subList(2, 5), (Object)this.testList.subList(2, 5));
        this.assertNoEvents();
    }

    @Test
    public void testToArray1() {
        Object[] temp = this.list.toArray();
        Vector<Object> v1 = new Vector<Object>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v1.addElement(temp[i]);
        }
        temp = this.testList.toArray();
        Vector<Object> v2 = new Vector<Object>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v2.addElement(temp[i]);
        }
        Assert.assertEquals(v1, v2);
        this.assertNoEvents();
    }

    @Test
    public void testToArray2() {
        String[] temp = this.list.toArray(new String[0]);
        Vector<String> v1 = new Vector<String>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v1.addElement(temp[i]);
        }
        temp = (String[])this.testList.toArray((Object[])new String[0]);
        Vector<String> v2 = new Vector<String>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v2.addElement(temp[i]);
        }
        Assert.assertEquals(v1, v2);
        this.assertNoEvents();
    }

    @Test
    public void testSort() {
        Assert.assertArrayEquals((Object[])this.list.toArray(), (Object[])this.testList.toArray());
        Comparator<String> c = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        };
        this.list.sort(c);
        this.testList.sort((Comparator)c);
        Assert.assertArrayEquals((Object[])this.list.toArray(), (Object[])this.testList.toArray());
        this.assertNoEvents();
    }

    @Test
    public void testSpliterator() {
        Assert.assertTrue((boolean)StreamSupport.stream(this.testList.spliterator(), true).allMatch(item -> this.list.contains(item)));
        Assert.assertTrue((boolean)StreamSupport.stream(this.list.spliterator(), true).allMatch(item -> this.testList.contains(item)));
        Assert.assertEquals((long)this.testList.size(), (long)this.testList.stream().count());
        this.assertNoEvents();
    }

    @Test
    public void testStream() {
        Assert.assertTrue((boolean)this.testList.stream().allMatch(item -> this.list.contains(item)));
        Assert.assertTrue((boolean)this.list.stream().allMatch(item -> this.testList.contains(item)));
        Assert.assertEquals((long)this.testList.size(), (long)this.testList.stream().count());
        this.assertNoEvents();
    }

    @Test
    public void testParallelStream() {
        Assert.assertTrue((boolean)this.testList.parallelStream().allMatch(item -> this.list.contains(item)));
        Assert.assertTrue((boolean)this.list.parallelStream().allMatch(item -> this.testList.contains(item)));
        Assert.assertEquals((long)this.testList.size(), (long)this.testList.parallelStream().count());
        this.assertNoEvents();
    }

    @Test
    public void testRemoveIf() {
        Assert.assertTrue((boolean)this.list.removeIf(item -> item.startsWith("s")));
        Assert.assertTrue((boolean)this.testList.removeIf(item -> item.startsWith("s")));
        Assert.assertEquals((String)"size do not match", (long)8L, (long)this.testList.size());
        Assert.assertArrayEquals((Object[])this.list.toArray(), (Object[])this.testList.toArray());
        this.assertRemoveEvents(2);
    }

    @Test
    public void testReplaceAll() {
        this.list.replaceAll(String::toUpperCase);
        this.testList.replaceAll(String::toUpperCase);
        Assert.assertArrayEquals((Object[])this.list.toArray(), (Object[])this.testList.toArray());
        this.assertRemoveAddEvents(this.testList.size());
    }

    @Test
    public void testForEach() {
        StringWriter sw1 = new StringWriter();
        StringWriter sw2 = new StringWriter();
        this.list.forEach(sw1::append);
        this.testList.forEach(sw2::append);
        Assert.assertArrayEquals((Object[])this.list.toArray(), (Object[])this.testList.toArray());
        Assert.assertEquals((Object)sw1.toString(), (Object)sw2.toString());
        this.assertNoEvents();
    }

    private void assertNoEvents() {
        if (this.useListener) {
            Assert.assertTrue((boolean)this.testListLsn.events.isEmpty());
        }
    }

    private void assertAddEvents(int count) {
        if (this.useListener) {
            Assert.assertEquals((String)"events do not match", (long)count, (long)this.testListLsn.events.size());
            for (CollectionChangeEvent cce : this.testListLsn.events) {
                Assert.assertEquals((String)"expected add event", (long)0L, (long)cce.getChangeType());
            }
        }
    }

    private void assertRemoveEvents(int count) {
        if (this.useListener) {
            Assert.assertEquals((String)"events do not match", (long)count, (long)this.testListLsn.events.size());
            for (CollectionChangeEvent cce : this.testListLsn.events) {
                Assert.assertEquals((String)"expected add event", (long)1L, (long)cce.getChangeType());
            }
        }
    }

    private void assertRemoveAddEvents(int count) {
        if (this.useListener) {
            int totalEvents = count * 2;
            Assert.assertEquals((String)"events do not match", (long)totalEvents, (long)this.testListLsn.events.size());
            int i = 0;
            while (i < totalEvents) {
                CollectionChangeEvent removeEvent = (CollectionChangeEvent)this.testListLsn.events.get(i++);
                CollectionChangeEvent addEvent = (CollectionChangeEvent)this.testListLsn.events.get(i++);
                Assert.assertEquals((String)"expected remove event", (long)1L, (long)removeEvent.getChangeType());
                Assert.assertEquals((String)"expected add event", (long)0L, (long)addEvent.getChangeType());
                Assert.assertFalse((String)("removed: '" + removeEvent.getNewValue() + "', new: '" + addEvent.getNewValue() + "'"), (boolean)removeEvent.getNewValue().equals(addEvent.getNewValue()));
            }
        }
    }

    private static final class Listener
    implements PropertyChangeListener {
        private List<CollectionChangeEvent> events = new ArrayList<CollectionChangeEvent>();

        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.events.add((CollectionChangeEvent)evt);
        }
    }

    public static final class L<E>
    extends IndirectList<E> {
    }
}

