/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryTest;

public class ReadObjectCheckCacheOnlyExpiryTest
extends CacheExpiryTest {
    protected Employee employee = null;
    protected Expression readExpression = null;

    public ReadObjectCheckCacheOnlyExpiryTest() {
        this.setDescription("Test ReadObjectQueries with check cache only to ensure they return the correct data.");
    }

    @Override
    public void setup() {
        super.setup();
        this.employee = (Employee)this.getSession().readObject(Employee.class);
        ExpressionBuilder empBuilder = new ExpressionBuilder();
        Expression readExpression = empBuilder.get("firstName").equal((Object)this.employee.getFirstName());
        readExpression = readExpression.and(empBuilder.get("lastName").equal((Object)this.employee.getLastName()));
        readExpression = readExpression.and(empBuilder.get("address").get("street").equal((Object)this.employee.getAddress().getStreet()));
        this.getAbstractSession().getIdentityMapAccessor().invalidateObject((Object)this.employee.getAddress());
        this.getAbstractSession().getIdentityMapAccessor().invalidateObject((Object)this.employee);
    }

    public void test() {
        ReadObjectQuery query = new ReadObjectQuery(Employee.class, this.readExpression);
        query.checkCacheOnly();
        this.employee = (Employee)this.getSession().executeQuery((DatabaseQuery)query);
    }

    public void verify() {
        if (this.employee != null) {
            throw new TestErrorException("ReadObjectQuery does not correctly ignore expired objects when set to checkCacheOnly.");
        }
    }
}

