/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class TestDataSource
implements DataSource {
    private String driverName;
    private String url;
    private Properties properties;

    public TestDataSource(String driverName, String url, Properties properties) {
        this.driverName = driverName;
        this.url = url;
        this.properties = properties;
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            Class.forName(this.driverName);
        }
        catch (ClassNotFoundException exception) {
            throw new RuntimeException("Driver Class not found: " + this.driverName);
        }
        return DriverManager.getConnection(this.url, this.properties);
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        this.properties.put("user", user);
        this.properties.put("password", password);
        return this.getConnection();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLoginTimeout(int arg1) throws SQLException {
    }

    @Override
    public void setLogWriter(PrintWriter arg1) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iFace) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iFace) throws SQLException {
        return iFace.cast(this);
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }
}

