/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class HelperSystemPropertyTest
extends AutoVerifyTestCase {
    public HelperSystemPropertyTest() {
        this.setDescription("Tests to ensure the Helper statics which access System Properties are correctly set.");
    }

    public void verify() {
        if (!Helper.cr().equals(System.getProperty("line.separator"))) {
            throw new TestErrorException("Helper.cr() returns the incorrect value.");
        }
        if (!Helper.pathSeparator().equals(System.getProperty("path.separator"))) {
            throw new TestErrorException("Helper.pathSeparator() returns the incorrect value.");
        }
        if (!Helper.fileSeparator().equals(System.getProperty("file.separator"))) {
            throw new TestErrorException("Helper.fileSeparator() returns the incorrect value.");
        }
        if (!Helper.currentWorkingDirectory().equals(System.getProperty("user.dir"))) {
            throw new TestErrorException("Helper.currentWorkingDirectory() returns the incorrect value.");
        }
        String tlTempDirectory = Helper.tempDirectory();
        String sysTempDirectory = System.getProperty("java.io.tmpdir");
        if (tlTempDirectory == null && sysTempDirectory != null || !tlTempDirectory.equals(sysTempDirectory)) {
            throw new TestErrorException("Helper.tempDirectory() returns the incorrect value.");
        }
    }
}

