/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections;

import java.util.Collection;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.Menu;
import org.eclipse.persistence.testing.models.collections.Restaurant;

public class PerformDeletesFirstCollectionObjectRemovalTest
extends TestCase {
    protected int startSize;
    protected int endSize;
    protected boolean shouldPerformDeletesFirst;
    protected boolean privateOwnedSetting;
    protected OneToManyMapping menusMapping;

    public PerformDeletesFirstCollectionObjectRemovalTest(boolean shouldPerformDeletesFirst) {
        this.setDescription("Test removing an element from a collection with UoW shouldPerformDeletesFirst");
        this.shouldPerformDeletesFirst = shouldPerformDeletesFirst;
    }

    protected void setup() {
        this.menusMapping = (OneToManyMapping)this.getSession().getDescriptor(Restaurant.class).getMappingForAttributeName("menus");
        this.privateOwnedSetting = this.menusMapping.isPrivateOwned();
        this.menusMapping.setIsPrivateOwned(false);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.beginTransaction();
    }

    protected void test() {
        Restaurant restaurantOriginal = (Restaurant)this.getSession().readObject(Restaurant.class, new ExpressionBuilder().get("name").equal((Object)"Chez Abuse"));
        this.startSize = restaurantOriginal.getMenus().size();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Restaurant restaurantClone = (Restaurant)uow.registerObject((Object)restaurantOriginal);
        PerformDeletesFirstCollectionObjectRemovalTest.assertTrue((restaurantClone.getMenus() != null ? 1 : 0) != 0);
        Collection menus = restaurantClone.getMenus().values();
        PerformDeletesFirstCollectionObjectRemovalTest.assertFalse((boolean)menus.isEmpty());
        Menu menuClone = (Menu)menus.toArray()[0];
        PerformDeletesFirstCollectionObjectRemovalTest.assertNotNull((Object)menuClone);
        restaurantClone.setName("Chez Snooty");
        restaurantClone.removeMenu(menuClone);
        PerformDeletesFirstCollectionObjectRemovalTest.assertFalse((boolean)restaurantClone.getMenus().containsValue(menuClone));
        uow.deleteObject((Object)menuClone);
        uow.setShouldPerformDeletesFirst(this.shouldPerformDeletesFirst);
        uow.commit();
        this.endSize = restaurantOriginal.getMenus().size();
    }

    protected void verify() {
        if (this.endSize != this.startSize - 1) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Parent collection was not updated correctly.");
            buffer.append(Helper.cr());
            buffer.append("Start size: ");
            buffer.append(this.startSize);
            buffer.append(" End size: ");
            buffer.append(this.endSize);
            buffer.append(" Perform deletes first: ");
            buffer.append(this.shouldPerformDeletesFirst);
            throw new TestErrorException(buffer.toString());
        }
    }

    public void reset() {
        this.rollbackTransaction();
        this.menusMapping.setIsPrivateOwned(this.privateOwnedSetting);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }
}

