/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.mappings.AggregateCollectionMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.aggregate.Company;
import org.eclipse.persistence.testing.models.aggregate.Customer;
import org.eclipse.persistence.testing.tests.aggregate.AgentBuilderHelper;

public class VerifyCascadeDelete
extends TransactionalTestCase {
    public Class cls;
    public Company company;
    public Object object;
    private OneToOneMapping companyMapping;
    private boolean privateOwnedValue = false;

    public VerifyCascadeDelete(Class cls) {
        this.cls = cls;
        this.setName(this.getName() + AgentBuilderHelper.getNameInBrackets(cls));
        this.setDescription("Verifies that deletes in an aggregate collections does not cascade to non-privately owned children");
    }

    public void setup() {
        super.setup();
        ClassDescriptor parentDescriptor = this.getSession().getDescriptor(this.cls);
        ClassDescriptor customerDescriptor = ((AggregateCollectionMapping)parentDescriptor.getMappingForAttributeName("customers")).getReferenceDescriptor();
        this.companyMapping = (OneToOneMapping)customerDescriptor.getMappingForAttributeName("company");
        this.privateOwnedValue = this.companyMapping.isPrivateOwned();
        this.companyMapping.setIsPrivateOwned(false);
        Vector objects = this.getSession().readAllObjects(this.cls);
        for (int index = 0; index < objects.size(); ++index) {
            this.object = objects.get(index);
            if (AgentBuilderHelper.getCustomers(this.object).size() <= 0) continue;
            this.company = ((Customer)AgentBuilderHelper.getCustomers(this.object).get(0)).getCompany();
            break;
        }
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Object objectClone = uow.readObject(this.object);
        AgentBuilderHelper.getCustomers(objectClone).clear();
        uow.commit();
    }

    public void verify() {
        if (this.getSession().readObject((Object)this.company) == null) {
            throw new TestErrorException("Cascaded the delete of a non-private part.");
        }
    }

    public void reset() {
        super.reset();
        this.companyMapping.setIsPrivateOwned(this.privateOwnedValue);
    }
}

