/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.orderedlist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.persistence.internal.helper.IndexedObject;
import org.eclipse.persistence.internal.queries.OrderedListContainerPolicy;

public class NullsLastOrderedListContainerPolicy
extends OrderedListContainerPolicy {
    static NullsLastComparator nullsLastComparator = new NullsLastComparator();

    public NullsLastOrderedListContainerPolicy() {
    }

    public NullsLastOrderedListContainerPolicy(Class containerClass) {
        super(containerClass);
    }

    public NullsLastOrderedListContainerPolicy(String containerClassName) {
        super(containerClassName);
    }

    public List correctOrderList(List<IndexedObject> indexedObjects) {
        Collections.sort(indexedObjects, nullsLastComparator);
        int size = indexedObjects.size();
        ArrayList<Object> objects = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            objects.add(indexedObjects.get(i).getObject());
        }
        return objects;
    }

    static class NullsLastComparator
    implements Comparator<IndexedObject> {
        NullsLastComparator() {
        }

        @Override
        public int compare(IndexedObject indexedObject1, IndexedObject indexedObject2) {
            Integer index1 = indexedObject1.getIndex();
            Integer index2 = indexedObject2.getIndex();
            if (index1 == null) {
                if (index2 == null) {
                    return 0;
                }
                return 1;
            }
            if (index2 == null) {
                return -1;
            }
            return index1.compareTo(index2);
        }
    }
}

