/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.collections;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.descriptors.changetracking.MapChangeEvent;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public abstract class Person
implements Comparable,
ChangeTracker {
    private String firstName;
    private String lastName;
    private BigDecimal id;
    public PropertyChangeListener listener;

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this.listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener listener) {
        this.listener = listener;
    }

    public void propertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.listener != null && oldValue != newValue) {
            this.listener.propertyChange(new PropertyChangeEvent(this, propertyName, oldValue, newValue));
        }
    }

    public void collectionChange(String propertyName, Collection changedCollection, Object newObject, int changeType, boolean isChangeApplied) {
        if (this.listener != null) {
            this.listener.propertyChange((PropertyChangeEvent)new CollectionChangeEvent((Object)this, propertyName, (Object)changedCollection, newObject, changeType, isChangeApplied));
        }
    }

    public void mapChange(String propertyName, Map changedCollection, Object key, Object newObject, int changeType, boolean isChangeApplied) {
        if (this.listener != null) {
            this.listener.propertyChange((PropertyChangeEvent)new MapChangeEvent((Object)this, propertyName, (Object)changedCollection, key, newObject, changeType, isChangeApplied));
        }
    }

    public int compareTo(Object o) {
        return this.lastName.compareTo(((Person)o).getLastName());
    }

    public String getFirstName() {
        return this.firstName;
    }

    public BigDecimal getId() {
        return this.id;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setFirstName(String newValue) {
        this.propertyChange("firstName", this.firstName, newValue);
        this.firstName = newValue;
    }

    public void setId(BigDecimal newValue) {
        this.propertyChange("id", this.id, newValue);
        this.id = newValue;
    }

    public void setLastName(String newValue) {
        this.propertyChange("lastName", this.lastName, newValue);
        this.lastName = newValue;
    }

    public static TableDefinition tableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("COL_PERS");
        definition.addIdentityField("ID", BigDecimal.class);
        definition.addField("CLASS", String.class, 1);
        definition.addField("F_NAME", String.class, 40);
        definition.addField("L_NAME", String.class, 40);
        definition.addField("SPECIALT", String.class, 100);
        definition.addField("W_RST_ID", BigDecimal.class, 15);
        return definition;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + ": " + this.getFirstName() + " " + this.getLastName();
    }
}

