/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.collections;

import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.models.collections.CollectionsProject;
import org.eclipse.persistence.testing.models.collections.Diner;
import org.eclipse.persistence.testing.models.collections.Location;
import org.eclipse.persistence.testing.models.collections.Menu;
import org.eclipse.persistence.testing.models.collections.MenuItem;
import org.eclipse.persistence.testing.models.collections.Person;
import org.eclipse.persistence.testing.models.collections.Restaurant;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;

public class CollectionsSystem
extends TestSystem {
    public CollectionsSystem() {
        this.project = new CollectionsProject();
    }

    public void addDescriptors(DatabaseSession session) {
        if (this.project == null) {
            this.project = new CollectionsProject();
        }
        session.addDescriptors(this.project);
    }

    public void createTables(DatabaseSession session) {
        SchemaManager schemaManager = new SchemaManager(session);
        schemaManager.replaceObject((DatabaseObjectDefinition)MenuItem.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)Menu.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)Person.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)Location.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)Location.relationTableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)Location.relation2TableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)Diner.relationTableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)Restaurant.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)Restaurant.sloganTableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)Restaurant.servicesTableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)Restaurant.licensesTableDefinition());
        schemaManager.createSequences();
    }

    public void populate(DatabaseSession session) {
        PopulationManager manager = PopulationManager.getDefaultManager();
        UnitOfWork uow = session.acquireUnitOfWork();
        Location location1 = Location.example1();
        Location location2 = Location.example2();
        Location location3 = Location.example3();
        Location location4 = Location.example4();
        Location location5 = Location.example5();
        Location location6 = Location.example6();
        Diner diner1 = Diner.example1();
        Diner diner2 = Diner.example2();
        Diner diner3 = Diner.example3();
        Restaurant instance1 = Restaurant.example1();
        instance1.addLocation(location1);
        instance1.addLocation(location2);
        instance1.addDiner(diner1);
        instance1.addDiner(diner2);
        manager.registerObject((Object)instance1, "example1");
        Restaurant instance2 = Restaurant.example2();
        instance2.addLocation(location2);
        instance2.addLocation(location3);
        instance2.addLocation(location4);
        instance2.addDiner(diner2);
        instance2.addDiner(diner3);
        manager.registerObject((Object)instance2, "example2");
        uow.registerObject((Object)instance1);
        uow.registerObject((Object)instance2);
        uow.commit();
    }
}

