/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.relationships;

import java.util.HashMap;
import javax.persistence.EntityManager;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.relationships.MtoMEntityA;
import org.eclipse.persistence.testing.models.jpa.relationships.MtoMEntityB;
import org.eclipse.persistence.testing.models.jpa.relationships.RelationshipsTableManager;

public class TestKeyTypeToManyRelationship
extends JUnitTestCase {
    public TestKeyTypeToManyRelationship() {
    }

    public TestKeyTypeToManyRelationship(String name) {
        super(name);
    }

    public void testSetup() {
        new RelationshipsTableManager().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TestKeyTypeToManyRelationship");
        suite.addTest((Test)new TestKeyTypeToManyRelationship("testSetup"));
        suite.addTest((Test)new TestKeyTypeToManyRelationship("testManyToManyMapTypeWithDefaultKey"));
        suite.addTest((Test)new TestKeyTypeToManyRelationship("testManyToManyMapTypeWithDefaultJointTable"));
        return suite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testManyToManyMapTypeWithDefaultJointTable() throws Exception {
        HashMap<String, String> emProps = new HashMap<String, String>();
        emProps.put("eclipselink.cache.shared.default", "false");
        EntityManager em = this.createEntityManager(emProps);
        this.beginTransaction(em);
        try {
            MtoMEntityA entityA = new MtoMEntityA();
            entityA.setId(2);
            entityA.setName("Entity A");
            em.persist((Object)entityA);
            MtoMEntityB entityB = new MtoMEntityB();
            entityB.setId(2);
            entityB.setName("Entity B");
            em.persist((Object)entityB);
            entityA.getEntityBDefault().put(2, entityB);
            this.commitTransaction(em);
            this.beginTransaction(em);
            em.clear();
            MtoMEntityA entityA_find = (MtoMEntityA)em.find(MtoMEntityA.class, (Object)2);
            TestKeyTypeToManyRelationship.assertNotSame((Object)entityA, (Object)entityA_find);
            TestKeyTypeToManyRelationship.assertNotNull((Object)entityA_find);
            TestKeyTypeToManyRelationship.assertNotNull((Object)entityA_find.getEntityBDefault());
            TestKeyTypeToManyRelationship.assertEquals((int)1, (int)entityA_find.getEntityBDefault().size());
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testManyToManyMapTypeWithDefaultKey() throws Exception {
        HashMap<String, String> emProps = new HashMap<String, String>();
        emProps.put("eclipselink.cache.shared.default", "false");
        EntityManager em = this.createEntityManager(emProps);
        this.beginTransaction(em);
        try {
            MtoMEntityA entityA = new MtoMEntityA();
            entityA.setId(1);
            entityA.setName("Entity A");
            em.persist((Object)entityA);
            MtoMEntityB entityB = new MtoMEntityB();
            entityB.setId(1);
            entityB.setName("Entity B");
            em.persist((Object)entityB);
            entityA.getEntityB().put(1, entityB);
            this.commitTransaction(em);
            this.beginTransaction(em);
            em.clear();
            MtoMEntityA entityA_find = (MtoMEntityA)em.find(MtoMEntityA.class, (Object)1);
            TestKeyTypeToManyRelationship.assertNotSame((Object)entityA, (Object)entityA_find);
            TestKeyTypeToManyRelationship.assertNotNull((Object)entityA_find);
            TestKeyTypeToManyRelationship.assertNotNull((Object)entityA_find.getEntityB());
            TestKeyTypeToManyRelationship.assertEquals((int)1, (int)entityA_find.getEntityB().size());
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }
}

