/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.memory;

import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.spi.PersistenceProvider;
import junit.framework.Test;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.MemoryLeakTestCase;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.models.jpa.performance.Address;
import org.eclipse.persistence.testing.models.jpa.performance.Employee;
import org.eclipse.persistence.testing.models.jpa.performance.EmployeeTableCreator;
import org.eclipse.persistence.testing.models.jpa.performance.EmploymentPeriod;
import org.eclipse.persistence.testing.models.jpa.performance.PhoneNumber;

public class JPAMemoryLeakModel
extends TestModel {
    public JPAMemoryLeakModel() {
        this.setDescription("Memory tests that test for memory leaks.");
    }

    public void addTests() {
        this.addTest((Test)this.buildReadTest());
        this.addTest((Test)this.buildInsertTest());
        this.addTest((Test)this.buildUpdateTest());
        this.addTest((Test)this.buildParameterizedBatchWriteTest());
        this.addTest((Test)this.buildExpressionCacheTest());
    }

    public void setup() {
        this.setupProvider();
        this.getSession().logMessage(this.getExecutor().getEntityManagerFactory().getClass().toString());
        System.out.println(this.getExecutor().getEntityManagerFactory().getClass().toString());
        EntityManager manager = this.getExecutor().createEntityManager();
        try {
            new EmployeeTableCreator().replaceTables((DatabaseSession)((JpaEntityManager)manager).getServerSession());
        }
        catch (ClassCastException cast) {
            new EmployeeTableCreator().replaceTables(this.getDatabaseSession());
        }
        manager.getTransaction().begin();
        for (int j = 0; j < 100; ++j) {
            Employee empInsert = new Employee();
            empInsert.setFirstName("Brendan");
            empInsert.setMale();
            empInsert.setLastName("" + j + "");
            empInsert.setSalary(100000);
            EmploymentPeriod employmentPeriod = new EmploymentPeriod();
            Date startDate = Helper.dateFromString((String)"1901-12-31");
            Date endDate = Helper.dateFromString((String)"1895-01-01");
            employmentPeriod.setEndDate(startDate);
            employmentPeriod.setStartDate(endDate);
            empInsert.setPeriod(employmentPeriod);
            empInsert.setAddress(new Address());
            empInsert.getAddress().setCity("Nepean");
            empInsert.getAddress().setPostalCode("N5J2N5");
            empInsert.getAddress().setProvince("ON");
            empInsert.getAddress().setStreet("1111 Mountain Blvd. Floor 13, suite " + j);
            empInsert.getAddress().setCountry("Canada");
            empInsert.addPhoneNumber(new PhoneNumber("Work Fax", "613", "2255943"));
            empInsert.addPhoneNumber(new PhoneNumber("Home", "613", "2224599"));
            manager.persist((Object)empInsert);
        }
        manager.getTransaction().commit();
        manager.close();
    }

    public void setupProvider() {
        String providerClass = "org.eclipse.persistence.jpa.PersistenceProvider";
        PersistenceProvider provider = null;
        try {
            provider = (PersistenceProvider)Class.forName(providerClass).newInstance();
        }
        catch (Exception error) {
            throw new TestProblemException("Failed to create persistence provider.", (Throwable)error);
        }
        Map properties = this.getPersistenceProperties();
        this.getExecutor().setEntityManagerFactory(provider.createEntityManagerFactory("performance", properties));
    }

    public Map getPersistenceProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("eclipselink.jdbc.driver", this.getSession().getLogin().getDriverClassName());
        properties.put("eclipselink.jdbc.url", this.getSession().getLogin().getConnectionString());
        properties.put("eclipselink.jdbc.user", this.getSession().getLogin().getUserName());
        properties.put("eclipselink.jdbc.password", this.getSession().getLogin().getPassword());
        properties.put("eclipselink.logging.level", this.getSession().getSessionLog().getLevelString());
        properties.put("eclipselink.jdbc.cache-statements", "true");
        return properties;
    }

    public TestCase buildInsertTest() {
        MemoryLeakTestCase test = new MemoryLeakTestCase(){

            public void test() {
                EntityManager manager = this.createEntityManager();
                ((JpaEntityManager)manager).getUnitOfWork().getParent().getIdentityMapAccessor().initializeAllIdentityMaps();
                manager.getTransaction().begin();
                for (int count = 0; count < 500; ++count) {
                    Employee employee = new Employee();
                    employee.setFirstName("NewGuy");
                    employee.setLastName("Smith");
                    manager.persist((Object)employee);
                    this.addWeakReference(employee);
                }
                manager.getTransaction().commit();
                Query query = manager.createQuery("Select e from Employee e");
                query.setHint("eclipselink.read-only", (Object)true);
                query.setHint("eclipselink.cache-usage", (Object)"CheckCacheOnly");
                this.addWeakReferences(query.getResultList());
                this.addWeakReference(manager);
                this.addWeakReference(((JpaEntityManager)manager).getUnitOfWork());
                this.addWeakReference(((JpaEntityManager)manager).getUnitOfWork().getParent());
                manager.close();
            }

            public void reset() {
                this.getSession().executeNonSelectingSQL("Delete from P_EMPLOYEE where F_NAME = 'NewGuy'");
            }
        };
        test.setName("InsertMemoryLeakTest");
        test.setThreshold(100);
        return test;
    }

    public TestCase buildUpdateTest() {
        MemoryLeakTestCase test = new MemoryLeakTestCase(){

            public void test() {
                EntityManager manager = this.createEntityManager();
                ((JpaEntityManager)manager).getUnitOfWork().getParent().getIdentityMapAccessor().initializeAllIdentityMaps();
                manager.getTransaction().begin();
                Query query = manager.createQuery("Select e from Employee e");
                List employees = query.getResultList();
                for (Employee employee : employees) {
                    employee.setFirstName("UpdatedGuy");
                    this.addWeakReference(employee);
                }
                manager.getTransaction().commit();
                query = manager.createQuery("Select e from Employee e");
                query.setHint("eclipselink.return-shared", (Object)true);
                this.addWeakReferences(query.getResultList());
                this.addWeakReference(manager);
                this.addWeakReference(((JpaEntityManager)manager).getUnitOfWork());
                this.addWeakReference(((JpaEntityManager)manager).getUnitOfWork().getParent());
                manager.close();
            }
        };
        test.setName("UpdateMemoryLeakTest");
        test.setThreshold(100);
        return test;
    }

    public TestCase buildExpressionCacheTest() {
        MemoryLeakTestCase test = new MemoryLeakTestCase(){

            public void test() {
                EntityManager manager = this.createEntityManager();
                manager.getTransaction().begin();
                ((JpaEntityManager)manager).getUnitOfWork().getParent().getIdentityMapAccessor().initializeAllIdentityMaps();
                DescriptorQueryManager queryManager = ((JpaEntityManager)manager).getUnitOfWork().getDescriptor(Employee.class).getQueryManager();
                queryManager.setExpressionQueryCacheMaxSize(queryManager.getExpressionQueryCacheMaxSize());
                ((JpaEntityManager)manager).getUnitOfWork().readAllObjects(Employee.class);
                this.addWeakReference(((JpaEntityManager)manager).getUnitOfWork());
                manager.getTransaction().commit();
                this.addWeakReference(manager);
                this.addWeakReference(((JpaEntityManager)manager).getUnitOfWork());
                this.addWeakReference(((JpaEntityManager)manager).getUnitOfWork().getParent());
                manager.close();
            }
        };
        test.setName("ExpressionCacheTest");
        return test;
    }

    public TestCase buildReadTest() {
        MemoryLeakTestCase test = new MemoryLeakTestCase(){

            public void test() {
                EntityManager manager = this.createEntityManager();
                ((JpaEntityManager)manager).getUnitOfWork().getParent().getIdentityMapAccessor().initializeAllIdentityMaps();
                Query query = manager.createQuery("Select e from Employee e");
                query.setHint("eclipselink.return-shared", (Object)true);
                this.addWeakReferences(query.getResultList());
                this.addWeakReference(query);
                query = manager.createQuery("Select e from Employee e");
                this.addWeakReferences(query.getResultList());
                this.addWeakReference(query);
                this.addWeakReference(manager);
                this.addWeakReference(((JpaEntityManager)manager).getUnitOfWork());
                this.addWeakReference(((JpaEntityManager)manager).getUnitOfWork().getParent());
                manager.close();
            }
        };
        test.setName("ReadMemoryLeakTest");
        test.setThreshold(100);
        return test;
    }

    public TestCase buildParameterizedBatchWriteTest() {
        MemoryLeakTestCase test = new MemoryLeakTestCase(){

            public void test() {
                boolean shouldBindAllParameters;
                EntityManager manager = this.createEntityManager();
                boolean usesBatchWriting = ((JpaEntityManager)manager).getServerSession().getPlatform().usesBatchWriting();
                if (!usesBatchWriting) {
                    ((JpaEntityManager)manager).getServerSession().getPlatform().setUsesBatchWriting(true);
                }
                if (!(shouldBindAllParameters = ((JpaEntityManager)manager).getServerSession().getPlatform().shouldBindAllParameters())) {
                    ((JpaEntityManager)manager).getServerSession().getPlatform().setShouldBindAllParameters(true);
                }
                manager.getTransaction().begin();
                for (int count = 0; count < 5; ++count) {
                    Employee employee = new Employee();
                    employee.setFirstName("NewBatchGuy");
                    employee.setLastName("Smith");
                    manager.persist((Object)employee);
                    this.addWeakReference(employee);
                }
                this.addWeakReference(manager);
                this.addWeakReference(((JpaEntityManager)manager).getUnitOfWork());
                this.addWeakReference(((JpaEntityManager)manager).getUnitOfWork().getParent());
                manager.getTransaction().commit();
                if (!usesBatchWriting) {
                    ((JpaEntityManager)manager).getServerSession().getPlatform().setUsesBatchWriting(false);
                }
                if (!shouldBindAllParameters) {
                    ((JpaEntityManager)manager).getServerSession().getPlatform().setShouldBindAllParameters(false);
                }
                manager.close();
            }

            public void reset() {
                this.getSession().executeNonSelectingSQL("Delete from P_EMPLOYEE where F_NAME = 'NewBatchGuy'");
            }
        };
        test.setName("ParametrizedBatchWriteMemoryLeakTest");
        return test;
    }
}

