/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.fieldaccess.fetchgroups;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.config.DescriptorCustomizer;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.PhoneNumber;
import org.eclipse.persistence.testing.tests.jpa.fieldaccess.fetchgroups.BaseFetchGroupTests;

public class SimpleDefaultFetchGroupTests
extends BaseFetchGroupTests {
    public SimpleDefaultFetchGroupTests() {
    }

    public SimpleDefaultFetchGroupTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("SimpleDefaultFetchGroupTests");
        suite.addTest((Test)new SimpleDefaultFetchGroupTests("testSetup"));
        suite.addTest((Test)new SimpleDefaultFetchGroupTests("findDefaultFetchGroup"));
        suite.addTest((Test)new SimpleDefaultFetchGroupTests("singleResultDefaultFetchGroup"));
        suite.addTest((Test)new SimpleDefaultFetchGroupTests("resultListDefaultFetchGroup"));
        suite.addTest((Test)new SimpleDefaultFetchGroupTests("resultListWithJoinFetchAddress"));
        suite.addTest((Test)new SimpleDefaultFetchGroupTests("resultListWithJoinFetchAddress_AddressInFetchGroup"));
        suite.addTest((Test)new SimpleDefaultFetchGroupTests("singleResultNoFetchGroup"));
        suite.addTest((Test)new SimpleDefaultFetchGroupTests("resultListNoFetchGroup"));
        suite.addTest((Test)new SimpleDefaultFetchGroupTests("emptyFetchGroup"));
        suite.addTest((Test)new SimpleDefaultFetchGroupTests("managerFetchGroup"));
        suite.addTest((Test)new SimpleDefaultFetchGroupTests("employeeNamesFetchGroup"));
        suite.addTest((Test)new SimpleDefaultFetchGroupTests("namedEmptyFetchGroupUsingGetSingleResult"));
        suite.addTest((Test)new SimpleDefaultFetchGroupTests("namedNamesFetchGroupUsingGetSingleResult"));
        suite.addTest((Test)new SimpleDefaultFetchGroupTests("joinFetchEmployeeAddressWithDynamicFetchGroup"));
        suite.addTest((Test)new SimpleDefaultFetchGroupTests("joinFetchEmployeeAddressPhoneWithDynamicFetchGroup"));
        suite.addTest((Test)new SimpleDefaultFetchGroupTests("joinFetchEmployeeAddressPhoneWithDynamicFetchGroup_AddressInFetchGroup"));
        return suite;
    }

    @Override
    public void setUp() {
        super.setUp();
        try {
            new EmployeeCustomizer().customize(this.employeeDescriptor);
            new BaseFetchGroupTests.PhoneCustomizer().customize(this.phoneDescriptor);
            this.reprepareReadQueries(this.employeeDescriptor);
            this.reprepareReadQueries(this.phoneDescriptor);
        }
        catch (RuntimeException rtEx) {
            throw rtEx;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        FetchGroup defaultEmpFG = this.employeeDescriptor.getDefaultFetchGroup();
        FetchGroup defaultPhoneFG = this.phoneDescriptor.getDefaultFetchGroup();
        SimpleDefaultFetchGroupTests.assertConfig(this.employeeDescriptor, defaultEmpFG, 0);
        SimpleDefaultFetchGroupTests.assertConfig(this.phoneDescriptor, defaultPhoneFG, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void findDefaultFetchGroup() throws Exception {
        EntityManager em = SimpleDefaultFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Employee emp = SimpleDefaultFetchGroupTests.minimumEmployee(em);
            SimpleDefaultFetchGroupTests.assertNotNull((Object)emp);
            SimpleDefaultFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleDefaultFetchGroupTests.assertDefaultFetched(emp);
            SimpleDefaultFetchGroupTests.assertNotFetchedAttribute(emp, "salary");
            emp.getSalary();
            SimpleDefaultFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleDefaultFetchGroupTests.assertFetchedAttribute(emp, "salary");
            SimpleDefaultFetchGroupTests.assertNoFetchGroup(emp.getAddress());
            SimpleDefaultFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                SimpleDefaultFetchGroupTests.assertDefaultFetched(phone);
            }
            SimpleDefaultFetchGroupTests.assertEquals((int)4, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            if (emp.getManager() != null) {
                SimpleDefaultFetchGroupTests.assertDefaultFetched(emp.getManager());
                SimpleDefaultFetchGroupTests.assertEquals((int)5, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            } else {
                SimpleDefaultFetchGroupTests.assertEquals((int)4, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void singleResultDefaultFetchGroup() throws Exception {
        EntityManager em = SimpleDefaultFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = :ID");
            query.setParameter("ID", (Object)SimpleDefaultFetchGroupTests.minimumEmployeeId(em));
            Employee emp = (Employee)query.getSingleResult();
            SimpleDefaultFetchGroupTests.assertNotNull((Object)emp);
            SimpleDefaultFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleDefaultFetchGroupTests.assertDefaultFetched(emp);
            emp.getSalary();
            SimpleDefaultFetchGroupTests.assertFetchedAttribute(emp, "salary");
            SimpleDefaultFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleDefaultFetchGroupTests.assertNoFetchGroup(emp.getAddress());
            SimpleDefaultFetchGroupTests.assertEquals((int)4, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                SimpleDefaultFetchGroupTests.assertDefaultFetched(phone);
            }
            SimpleDefaultFetchGroupTests.assertEquals((int)5, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            if (emp.getManager() != null) {
                SimpleDefaultFetchGroupTests.assertDefaultFetched(emp.getManager());
                SimpleDefaultFetchGroupTests.assertEquals((int)6, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            } else {
                SimpleDefaultFetchGroupTests.assertEquals((int)5, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void resultListDefaultFetchGroup() throws Exception {
        EntityManager em = SimpleDefaultFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = :ID");
            query.setParameter("ID", (Object)SimpleDefaultFetchGroupTests.minimumEmployeeId(em));
            List emps = query.getResultList();
            SimpleDefaultFetchGroupTests.assertNotNull((Object)emps);
            SimpleDefaultFetchGroupTests.assertEquals((int)1, (int)emps.size());
            Employee emp = (Employee)emps.get(0);
            SimpleDefaultFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleDefaultFetchGroupTests.assertDefaultFetched(emp);
            emp.getSalary();
            SimpleDefaultFetchGroupTests.assertNoFetchGroup(emp);
            SimpleDefaultFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleDefaultFetchGroupTests.assertNoFetchGroup(emp.getAddress());
            SimpleDefaultFetchGroupTests.assertEquals((int)4, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                SimpleDefaultFetchGroupTests.assertDefaultFetched(phone);
            }
            SimpleDefaultFetchGroupTests.assertEquals((int)5, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            if (emp.getManager() != null) {
                SimpleDefaultFetchGroupTests.assertDefaultFetched(emp.getManager());
                SimpleDefaultFetchGroupTests.assertEquals((int)6, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            } else {
                SimpleDefaultFetchGroupTests.assertEquals((int)5, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    @org.junit.Test
    public void resultListWithJoinFetchAddress() {
        this.internalResultListWithJoinFetchAddress(false);
    }

    @org.junit.Test
    public void resultListWithJoinFetchAddress_AddressInFetchGroup() {
        this.internalResultListWithJoinFetchAddress(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalResultListWithJoinFetchAddress(boolean addAddressToFetchGroup) {
        EntityManager em = SimpleDefaultFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e JOIN FETCH e.address WHERE e.id = :ID");
            query.setParameter("ID", (Object)SimpleDefaultFetchGroupTests.minimumEmployeeId(em));
            SimpleDefaultFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            FetchGroup fg = null;
            if (addAddressToFetchGroup) {
                fg = this.employeeDescriptor.getFetchGroupManager().createDefaultFetchGroup();
                fg.addAttribute("address");
                query.setHint("eclipselink.fetch-group", (Object)fg);
            }
            Employee emp = (Employee)query.getSingleResult();
            int nSql = 2;
            if (!addAddressToFetchGroup) {
                nSql += 2;
            }
            SimpleDefaultFetchGroupTests.assertEquals((int)nSql, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            if (addAddressToFetchGroup) {
                SimpleDefaultFetchGroupTests.assertFetched((Object)emp, fg);
            } else {
                SimpleDefaultFetchGroupTests.assertNoFetchGroup(emp);
            }
            emp.getSalary();
            SimpleDefaultFetchGroupTests.assertNoFetchGroup(emp);
            if (addAddressToFetchGroup) {
                ++nSql;
            }
            SimpleDefaultFetchGroupTests.assertEquals((int)nSql, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleDefaultFetchGroupTests.assertNoFetchGroup(emp.getAddress());
            SimpleDefaultFetchGroupTests.assertEquals((int)nSql, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                SimpleDefaultFetchGroupTests.assertDefaultFetched(phone);
            }
            SimpleDefaultFetchGroupTests.assertEquals((int)(++nSql), (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            if (emp.getManager() != null) {
                SimpleDefaultFetchGroupTests.assertDefaultFetched(emp.getManager());
                SimpleDefaultFetchGroupTests.assertEquals((int)(++nSql), (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            } else {
                SimpleDefaultFetchGroupTests.assertEquals((int)nSql, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void singleResultNoFetchGroup() throws Exception {
        EntityManager em = SimpleDefaultFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = :ID");
            query.setParameter("ID", (Object)SimpleDefaultFetchGroupTests.minimumEmployeeId(em));
            SimpleDefaultFetchGroupTests.assertNotNull((Object)this.employeeDescriptor.getFetchGroupManager().getDefaultFetchGroup());
            query.setHint("eclipselink.fetch-group.default", (Object)"false");
            SimpleDefaultFetchGroupTests.assertNull((Object)this.getFetchGroup(query));
            Employee emp = (Employee)query.getSingleResult();
            SimpleDefaultFetchGroupTests.assertNotNull((Object)emp);
            SimpleDefaultFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleDefaultFetchGroupTests.assertNoFetchGroup(emp);
            SimpleDefaultFetchGroupTests.assertNoFetchGroup(emp.getAddress());
            SimpleDefaultFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                SimpleDefaultFetchGroupTests.assertDefaultFetched(phone);
            }
            SimpleDefaultFetchGroupTests.assertEquals((int)4, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void resultListNoFetchGroup() throws Exception {
        EntityManager em = SimpleDefaultFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = :ID");
            query.setParameter("ID", (Object)SimpleDefaultFetchGroupTests.minimumEmployeeId(em));
            query.setHint("eclipselink.fetch-group.default", (Object)"false");
            List emps = query.getResultList();
            SimpleDefaultFetchGroupTests.assertNotNull((Object)emps);
            SimpleDefaultFetchGroupTests.assertEquals((int)1, (int)emps.size());
            Employee emp = (Employee)emps.get(0);
            SimpleDefaultFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleDefaultFetchGroupTests.assertNoFetchGroup(emp);
            SimpleDefaultFetchGroupTests.assertNoFetchGroup(emp.getAddress());
            SimpleDefaultFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                SimpleDefaultFetchGroupTests.assertDefaultFetched(phone);
            }
            SimpleDefaultFetchGroupTests.assertEquals((int)4, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void emptyFetchGroup() throws Exception {
        EntityManager em = SimpleDefaultFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = :ID");
            query.setParameter("ID", (Object)SimpleDefaultFetchGroupTests.minimumEmployeeId(em));
            FetchGroup emptyFG = new FetchGroup("empty@" + System.currentTimeMillis());
            query.setHint("eclipselink.fetch-group", (Object)emptyFG);
            SimpleDefaultFetchGroupTests.assertEquals((Object)emptyFG, (Object)this.getFetchGroup(query));
            Employee emp = (Employee)query.getSingleResult();
            SimpleDefaultFetchGroupTests.assertFetched((Object)emp, emptyFG);
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                SimpleDefaultFetchGroupTests.assertDefaultFetched(phone);
                phone.getAreaCode();
                SimpleDefaultFetchGroupTests.assertNoFetchGroup(phone);
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @org.junit.Test
    public void managerFetchGroup() throws Exception {
        EntityManager em = SimpleDefaultFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.manager IS NOT NULL AND NOT EXISTS(SELECT e2 FROM Employee e2 WHERE e2.manager = e) AND e.manager.department IS NULL");
            FetchGroup managerFG = new FetchGroup();
            managerFG.addAttribute("manager");
            query.setHint("eclipselink.fetch-group", (Object)managerFG);
            query.setHint("eclipselink.left-join-fetch", (Object)"e.manager");
            SimpleDefaultFetchGroupTests.assertEquals((Object)managerFG, (Object)this.getFetchGroup(query));
            List employees = query.getResultList();
            Employee emp = (Employee)employees.get(0);
            SimpleDefaultFetchGroupTests.assertFetched((Object)emp, managerFG);
            SimpleDefaultFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            emp.getManager();
            SimpleDefaultFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleDefaultFetchGroupTests.assertFetched((Object)emp, managerFG);
            emp.getLastName();
            SimpleDefaultFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleDefaultFetchGroupTests.assertNoFetchGroup(emp);
            int numPhones = 0;
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                SimpleDefaultFetchGroupTests.assertDefaultFetched(phone);
                phone.getAreaCode();
                SimpleDefaultFetchGroupTests.assertNoFetchGroup(phone);
                ++numPhones;
            }
            SimpleDefaultFetchGroupTests.assertEquals((int)(3 + numPhones), (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @org.junit.Test
    public void employeeNamesFetchGroup() throws Exception {
        EntityManager em = SimpleDefaultFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            int minId = SimpleDefaultFetchGroupTests.minimumEmployeeId(em);
            SimpleDefaultFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = :ID");
            query.setParameter("ID", (Object)minId);
            FetchGroup namesFG = new FetchGroup();
            namesFG.addAttribute("firstName");
            namesFG.addAttribute("lastName");
            query.setHint("eclipselink.fetch-group", (Object)namesFG);
            SimpleDefaultFetchGroupTests.assertNotNull((Object)this.getFetchGroup(query));
            SimpleDefaultFetchGroupTests.assertSame((Object)namesFG, (Object)this.getFetchGroup(query));
            Employee emp = (Employee)query.getSingleResult();
            SimpleDefaultFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleDefaultFetchGroupTests.assertFetched((Object)emp, namesFG);
            emp.getId();
            emp.getFirstName();
            emp.getLastName();
            emp.getVersion();
            SimpleDefaultFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleDefaultFetchGroupTests.assertFetched((Object)emp, namesFG);
            emp.getGender();
            emp.getSalary();
            SimpleDefaultFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            SimpleDefaultFetchGroupTests.assertNoFetchGroup(emp);
            int numPhones = 0;
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                SimpleDefaultFetchGroupTests.assertDefaultFetched(phone);
                phone.getAreaCode();
                SimpleDefaultFetchGroupTests.assertNoFetchGroup(phone);
                ++numPhones;
            }
            SimpleDefaultFetchGroupTests.assertEquals((int)(4 + numPhones), (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            if (emp.getManager() != null) {
                SimpleDefaultFetchGroupTests.assertEquals((int)(5 + numPhones), (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
                SimpleDefaultFetchGroupTests.assertDefaultFetched(emp.getManager());
            } else {
                SimpleDefaultFetchGroupTests.assertEquals((int)(4 + numPhones), (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    @org.junit.Test
    public void namedEmptyFetchGroupUsingGetSingleResult() throws Exception {
        FetchGroup fetchGroup = new FetchGroup("test");
        this.employeeDescriptor.getFetchGroupManager().addFetchGroup(fetchGroup);
        SimpleDefaultFetchGroupTests.assertTrue((boolean)fetchGroup.getItems().isEmpty());
        SimpleDefaultFetchGroupTests.assertEquals((int)1, (int)this.employeeDescriptor.getFetchGroupManager().getFetchGroups().size());
        EntityManager em = SimpleDefaultFetchGroupTests.createEntityManager((String)"fieldaccess");
        Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = :ID");
        query.setParameter("ID", (Object)SimpleDefaultFetchGroupTests.minimumEmployeeId(em));
        query.setHint("eclipselink.fetch-group.name", (Object)"test");
        Employee emp = (Employee)query.getSingleResult();
        SimpleDefaultFetchGroupTests.assertNotNull((Object)emp);
        SimpleDefaultFetchGroupTests.assertFetched((Object)emp, "test");
    }

    @org.junit.Test
    public void namedNamesFetchGroupUsingGetSingleResult() throws Exception {
        FetchGroup fetchGroup = new FetchGroup("names");
        fetchGroup.addAttribute("firstName");
        fetchGroup.addAttribute("lastName");
        this.employeeDescriptor.getFetchGroupManager().addFetchGroup(fetchGroup);
        SimpleDefaultFetchGroupTests.assertEquals((int)2, (int)fetchGroup.getItems().size());
        SimpleDefaultFetchGroupTests.assertEquals((int)1, (int)this.employeeDescriptor.getFetchGroupManager().getFetchGroups().size());
        EntityManager em = SimpleDefaultFetchGroupTests.createEntityManager((String)"fieldaccess");
        Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = :ID");
        query.setParameter("ID", (Object)SimpleDefaultFetchGroupTests.minimumEmployeeId(em));
        query.setHint("eclipselink.fetch-group.name", (Object)"names");
        Employee emp = (Employee)query.getSingleResult();
        SimpleDefaultFetchGroupTests.assertNotNull((Object)emp);
        FetchGroupTracker tracker = (FetchGroupTracker)emp;
        SimpleDefaultFetchGroupTests.assertNotNull((Object)tracker);
        FetchGroup usedFG = tracker._persistence_getFetchGroup();
        SimpleDefaultFetchGroupTests.assertNotNull((String)"No FetchGroup found on read Employee", (Object)fetchGroup);
        SimpleDefaultFetchGroupTests.assertTrue((boolean)fetchGroup.getAttributeNames().equals(usedFG.getAttributeNames()));
        SimpleDefaultFetchGroupTests.assertEquals((int)4, (int)fetchGroup.getItems().size());
        SimpleDefaultFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("id"));
        SimpleDefaultFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("version"));
        SimpleDefaultFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("salary"));
        SimpleDefaultFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("firstName"));
        SimpleDefaultFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("lastName"));
        SimpleDefaultFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("department"));
    }

    @Override
    @org.junit.Test
    public void joinFetchEmployeeAddressWithDynamicFetchGroup() {
        EntityManager em = SimpleDefaultFetchGroupTests.createEntityManager((String)"fieldaccess");
        Query query = em.createQuery("SELECT e FROM Employee e JOIN FETCH e.address");
        FetchGroup fetchGroup = new FetchGroup("names");
        fetchGroup.addAttribute("firstName");
        fetchGroup.addAttribute("lastName");
        query.setHint("eclipselink.fetch-group", (Object)fetchGroup);
        List emps = query.getResultList();
        SimpleDefaultFetchGroupTests.assertNotNull((Object)emps);
    }

    @Override
    @org.junit.Test
    public void joinFetchEmployeeAddressPhoneWithDynamicFetchGroup() {
        this.internalJoinFetchEmployeeAddressPhoneWithDynamicFetchGroup(false);
    }

    @org.junit.Test
    public void joinFetchEmployeeAddressPhoneWithDynamicFetchGroup_AddressInFetchGroup() {
        this.internalJoinFetchEmployeeAddressPhoneWithDynamicFetchGroup(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalJoinFetchEmployeeAddressPhoneWithDynamicFetchGroup(boolean addAddressToFetchGroup) {
        EntityManager em = SimpleDefaultFetchGroupTests.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e JOIN FETCH e.address WHERE e.id IN (SELECT p.owner.id FROM PhoneNumber p)");
            FetchGroup fetchGroup = new FetchGroup("names");
            fetchGroup.addAttribute("firstName");
            fetchGroup.addAttribute("lastName");
            if (addAddressToFetchGroup) {
                fetchGroup.addAttribute("address");
            }
            query.setHint("eclipselink.fetch-group", (Object)fetchGroup);
            List emps = query.getResultList();
            SimpleDefaultFetchGroupTests.assertNotNull((Object)emps);
            if (addAddressToFetchGroup) {
                SimpleDefaultFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            } else {
                SimpleDefaultFetchGroupTests.assertEquals((int)(1 + 2 * emps.size()), (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            }
            for (Employee emp : emps) {
                if (addAddressToFetchGroup) {
                    SimpleDefaultFetchGroupTests.assertFetched((Object)emp, fetchGroup);
                    continue;
                }
                SimpleDefaultFetchGroupTests.assertNoFetchGroup(emp);
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public static class EmployeeCustomizer
    implements DescriptorCustomizer {
        public void customize(ClassDescriptor descriptor) throws Exception {
            FetchGroup fg = new FetchGroup("Employee-default");
            fg.addAttribute("firstName");
            fg.addAttribute("lastName");
            descriptor.getFetchGroupManager().setDefaultFetchGroup(fg);
        }
    }
}

