/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.fetchgroups;

import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.tests.jpa.fetchgroups.BaseFetchGroupTests;

public class FetchGroupMergeWithCacheTests
extends BaseFetchGroupTests {
    public FetchGroupMergeWithCacheTests() {
    }

    public FetchGroupMergeWithCacheTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("FetchGroupMergeWithCacheTests");
        suite.addTest((Test)new FetchGroupMergeWithCacheTests("testSetup"));
        suite.addTest((Test)new FetchGroupMergeWithCacheTests("cacheFull_QueryWithFetchGroup_Simple"));
        if (!FetchGroupMergeWithCacheTests.isJPA10()) {
            suite.addTest((Test)new FetchGroupMergeWithCacheTests("cacheFull_FindWithFetchGroup_Simple"));
        }
        return suite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void cacheFull_QueryWithFetchGroup_Simple() throws Exception {
        EntityManager em = this.createEntityManager();
        Employee emp = this.findMinimumEmployee(em);
        int id = emp.getId();
        try {
            FetchGroupMergeWithCacheTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            this.assertNoFetchGroup(emp);
        }
        finally {
            this.closeEntityManager(em);
        }
        EntityManager em2 = this.createEntityManager();
        Query query = em2.createQuery("SELECT e FROM Employee e WHERE e.id = " + id);
        FetchGroup fg = new FetchGroup();
        fg.addAttribute("firstName");
        fg.addAttribute("lastName");
        query.setHint("eclipselink.fetch-group", (Object)fg);
        Employee resultEmployee = (Employee)query.getSingleResult();
        try {
            FetchGroupMergeWithCacheTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em2).getTotalSQLSELECTCalls());
            this.assertNoFetchGroup(resultEmployee);
        }
        finally {
            this.closeEntityManager(em2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void cacheFull_FindWithFetchGroup_Simple() throws Exception {
        EntityManager em = this.createEntityManager();
        Employee emp = this.findMinimumEmployee(em);
        int id = emp.getId();
        try {
            FetchGroupMergeWithCacheTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            this.assertNoFetchGroup(emp);
        }
        finally {
            this.closeEntityManager(em);
        }
        EntityManager em2 = this.createEntityManager();
        FetchGroup fg = new FetchGroup();
        fg.addAttribute("firstName");
        fg.addAttribute("lastName");
        HashMap<String, FetchGroup> properties = new HashMap<String, FetchGroup>(1);
        properties.put("eclipselink.fetch-group", fg);
        Employee resultEmployee = (Employee)em2.find(Employee.class, (Object)id, properties);
        try {
            FetchGroupMergeWithCacheTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em2).getTotalSQLSELECTCalls());
            this.assertNoFetchGroup(resultEmployee);
        }
        finally {
            this.closeEntityManager(em2);
        }
    }
}

