/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced.compositepk;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.Query;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.sessions.CopyGroup;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.compositepk.Author;
import org.eclipse.persistence.testing.models.jpa.advanced.compositepk.Book;
import org.eclipse.persistence.testing.models.jpa.advanced.compositepk.Competency;
import org.eclipse.persistence.testing.models.jpa.advanced.compositepk.CompositePKTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.compositepk.Cubicle;
import org.eclipse.persistence.testing.models.jpa.advanced.compositepk.Department;
import org.eclipse.persistence.testing.models.jpa.advanced.compositepk.DepartmentPK;
import org.eclipse.persistence.testing.models.jpa.advanced.compositepk.JuniorScientist;
import org.eclipse.persistence.testing.models.jpa.advanced.compositepk.Office;
import org.eclipse.persistence.testing.models.jpa.advanced.compositepk.OfficePK;
import org.eclipse.persistence.testing.models.jpa.advanced.compositepk.Scientist;
import org.eclipse.persistence.testing.models.jpa.advanced.compositepk.ScientistPK;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.AdminPool;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.Administrator;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.Bookie;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.BrigadierGeneral;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.Captain;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.CaptainId;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.CellNumber;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.CellNumberPK;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.Corporal;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.CorporalId;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.DepartmentAdminRole;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.DepartmentAdminRolePK;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.General;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.Lackey;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.LackeyCrewMember;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.LackeyCrewMemberId;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.Lieutenant;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.LieutenantGeneral;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.LieutenantId;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.Major;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.MajorGeneral;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.MajorId;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.MasterCorporal;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.MasterCorporalClone;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.MasterCorporalId;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.OfficerCadet;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.Private;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.PrivateId;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.Sargeant;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.SecondLieutenant;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.nested.GolfClub;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.nested.GolfClubHead;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.nested.GolfClubOrder;
import org.eclipse.persistence.testing.models.jpa.advanced.derivedid.nested.GolfClubShaft;

public class AdvancedCompositePKJunitTest
extends JUnitTestCase {
    private static DepartmentPK m_departmentPK;
    private static ScientistPK m_scientist1PK;
    private static ScientistPK m_scientist2PK;
    private static ScientistPK m_scientist3PK;
    private static ScientistPK m_jScientistPK;

    public AdvancedCompositePKJunitTest() {
    }

    public AdvancedCompositePKJunitTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("AdvancedCompositePKJunitTest");
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testSetup"));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testOrderBySetting"));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testCreateDepartment"));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testCreateScientists"));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testReadDepartment"));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testReadJuniorScientist"));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testAnyAndAll"));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testDepartmentAdmin"));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testMapsIdExample1"));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testMapsIdExample1b"));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testMapsIdExample2"));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testMapsIdExample3"));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testMapsIdExample4"));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testMapsIdExample5"));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testMapsIdExample5a"));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testMapsIdExample6"));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testMapsIdExample6MultiLevel"));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testJoinColumnSharesPK"));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testMapWithDerivedId"));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testIdentitySequencingForDerivedId"));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testSharedDerivedIdEmbeddableClass"));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testNestedMapsId"));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testCopyAggregateCollection"));
        if (!AdvancedCompositePKJunitTest.isJPA10()) {
            suite.addTest((Test)new AdvancedCompositePKJunitTest("testGetIdentifier"));
            suite.addTest((Test)new AdvancedCompositePKJunitTest("testFailedGetIdenitifier"));
            suite.addTest((Test)new AdvancedCompositePKJunitTest("testGetIdenitifierOnNonEntity"));
            suite.addTest((Test)new AdvancedCompositePKJunitTest("testNestedEmbeddableSequenceGeneration"));
        }
        return suite;
    }

    public void testSetup() {
        new CompositePKTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    public void testOrderBySetting() {
        ServerSession session = JUnitTestCase.getServerSession();
        ClassDescriptor departmentDescriptor = session.getDescriptor(Department.class);
        AdvancedCompositePKJunitTest.assertNotNull((String)"Department descriptor was not found.", (Object)departmentDescriptor);
        DatabaseMapping scientistMapping = departmentDescriptor.getMappingForAttributeName("scientists");
        AdvancedCompositePKJunitTest.assertNotNull((String)"Scientist mapping from Department descriptor was not found.", (Object)scientistMapping);
        AdvancedCompositePKJunitTest.assertTrue((String)"The scientist mapping from the Department descriptor did not have an order by setting.", (boolean)((OneToManyMapping)scientistMapping).hasOrderBy());
    }

    public void testCreateDepartment() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.createQuery("DELETE FROM Department d WHERE d.name = 'DEPT A' AND d.role = 'ROLE A' AND d.location = 'LOCATION A'").executeUpdate();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.clearCache();
        this.closeEntityManager(em);
        em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Department department = new Department();
            department.setName("DEPT A");
            department.setRole("ROLE A");
            department.setLocation("LOCATION A");
            Competency competency = new Competency();
            competency.description = "Manage groups";
            competency.rating = 9;
            department.addCompetency(competency);
            em.persist((Object)department);
            this.commitTransaction(em);
            m_departmentPK = department.getPK();
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testCreateScientists() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Department department = (Department)em.merge((Object)((Department)em.find(Department.class, (Object)m_departmentPK)));
            Cubicle cubicle1 = new Cubicle("G");
            em.persist((Object)cubicle1);
            Scientist scientist1 = new Scientist();
            scientist1.setFirstName("Guy");
            scientist1.setLastName("Pelletier");
            scientist1.setCubicle(cubicle1);
            department.addScientist(scientist1);
            em.persist((Object)scientist1);
            Cubicle cubicle2 = new Cubicle("T");
            em.persist((Object)cubicle2);
            Scientist scientist2 = new Scientist();
            scientist2.setFirstName("Tom");
            scientist2.setLastName("Ware");
            scientist2.setCubicle(cubicle2);
            department.addScientist(scientist2);
            em.persist((Object)scientist2);
            Cubicle cubicle3 = new Cubicle("G");
            em.persist((Object)cubicle3);
            Scientist scientist3 = new Scientist();
            scientist3.setFirstName("Gordon");
            scientist3.setLastName("Yorke");
            scientist3.setCubicle(cubicle3);
            department.addScientist(scientist3);
            em.persist((Object)scientist3);
            Cubicle cubicle4 = new Cubicle("J");
            em.persist((Object)cubicle4);
            JuniorScientist jScientist = new JuniorScientist();
            jScientist.setFirstName("Junior");
            jScientist.setLastName("Sao");
            jScientist.setCubicle(cubicle4);
            department.addScientist((Scientist)jScientist);
            em.persist((Object)jScientist);
            this.commitTransaction(em);
            m_scientist1PK = scientist1.getPK();
            m_scientist2PK = scientist2.getPK();
            m_scientist3PK = scientist3.getPK();
            m_jScientistPK = jScientist.getPK();
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testDepartmentAdmin() {
        String location = "Ottawa";
        String depName = "New Product Research";
        String depRole = "R&D new technologies";
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee emp = new Employee();
            emp.setFirstName("George");
            em.persist((Object)emp);
            Administrator adminEmp = new Administrator();
            adminEmp.setContractCompany("George's consulting");
            adminEmp.setEmployee(emp);
            em.persist((Object)adminEmp);
            Department newProductResearch = new Department();
            newProductResearch.setLocation(location);
            newProductResearch.setName(depName);
            newProductResearch.setRole(depRole);
            em.persist((Object)newProductResearch);
            DepartmentAdminRole depAdmin = new DepartmentAdminRole();
            depAdmin.setAdmin(adminEmp);
            depAdmin.setDepartment(newProductResearch);
            em.persist((Object)depAdmin);
            this.commitTransaction(em);
            DepartmentAdminRolePK depAdminPk = new DepartmentAdminRolePK(depName, depRole, location, adminEmp.getEmployee().getId().intValue());
            DepartmentAdminRole cacheObject = (DepartmentAdminRole)em.find(DepartmentAdminRole.class, (Object)depAdminPk);
            AdvancedCompositePKJunitTest.assertTrue((String)"Find did not return the DepartmentAdminRole", (cacheObject != null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testReadDepartment() {
        Department department = (Department)this.createEntityManager().find(Department.class, (Object)m_departmentPK);
        AdvancedCompositePKJunitTest.assertTrue((String)"Error on reading back the ordered department list.", (department != null ? 1 : 0) != 0);
        AdvancedCompositePKJunitTest.assertTrue((String)"The number of scientists were incorrect.", (department.getScientists().size() > 0 ? 1 : 0) != 0);
    }

    public void testReadJuniorScientist() {
        JuniorScientist jScientist = (JuniorScientist)this.createEntityManager().find(JuniorScientist.class, (Object)m_jScientistPK);
        AdvancedCompositePKJunitTest.assertTrue((String)"Error on reading back the junior scientist.", (jScientist != null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnyAndAll() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Query query1 = em.createQuery("SELECT s FROM Scientist s WHERE s = ANY (SELECT s2 FROM Scientist s2)");
            List results1 = query1.getResultList();
            Query query2 = em.createQuery("SELECT s FROM Scientist s WHERE s = ALL (SELECT s2 FROM Scientist s2)");
            List results2 = query2.getResultList();
            Query query3 = em.createQuery("SELECT s FROM Scientist s WHERE s.department = ALL (SELECT DISTINCT d FROM Department d WHERE d.name = 'DEPT A' AND d.role = 'ROLE A' AND d.location = 'LOCATION A')");
            List results3 = query3.getResultList();
            Query query4 = em.createQuery("SELECT s FROM Scientist s WHERE s.department = ANY (SELECT DISTINCT d FROM Department d JOIN d.scientists ds JOIN ds.cubicle c WHERE c.code = 'G')");
            List results4 = query4.getResultList();
            Query controlQuery1 = em.createQuery("SELECT s FROM Scientist s");
            ArrayList controlResults1 = controlQuery1.getResultList();
            ArrayList controlResults2 = controlResults1.size() == 1 ? controlResults1 : new ArrayList();
            Query controlQuery3 = em.createQuery("SELECT s FROM Scientist s JOIN s.department d WHERE d.name = 'DEPT A' AND d.role = 'ROLE A' AND d.location = 'LOCATION A'");
            List controlResults3 = controlQuery3.getResultList();
            Query controlQuery4 = em.createQuery("SELECT s FROM Scientist s WHERE EXISTS (SELECT DISTINCT d FROM Department d JOIN d.scientists ds JOIN ds.cubicle c WHERE c.code = 'G' AND d = s.department)");
            List controlResults4 = controlQuery4.getResultList();
            this.compareResults(results1, controlResults1, "query1");
            this.compareResults(results2, controlResults2, "query2");
            this.compareResults(results3, controlResults3, "query3");
            this.compareResults(results4, controlResults4, "query4");
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    protected void compareResults(List results, List controlResults, String testName) {
        if (results.size() != controlResults.size()) {
            AdvancedCompositePKJunitTest.fail((String)(testName + ": results.size() = " + results.size() + "; controlResults.size() = " + controlResults.size()));
        }
        for (Object s : results) {
            if (controlResults.contains(s)) continue;
            AdvancedCompositePKJunitTest.fail((String)(testName + ": " + s + "contained in results but not in controlResults"));
        }
    }

    public void testMapsIdExample1() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Sargeant sargeant = new Sargeant();
        MasterCorporal masterCorporal = new MasterCorporal();
        MasterCorporalId masterCorporalId = new MasterCorporalId();
        try {
            sargeant.setName("Sarge");
            masterCorporalId.setName("Corpie");
            masterCorporal.setId(masterCorporalId);
            masterCorporal.setSargeant(sargeant);
            em.persist((Object)masterCorporal);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.clearCache();
        em = this.createEntityManager();
        Sargeant refreshedSargeant = (Sargeant)em.find(Sargeant.class, (Object)sargeant.getSargeantId());
        AdvancedCompositePKJunitTest.assertTrue((String)"The sargeant read back did not match the original", (boolean)AdvancedCompositePKJunitTest.getServerSession().compareObjects((Object)sargeant, (Object)refreshedSargeant));
        MasterCorporal refreshedMasterCorporal = (MasterCorporal)em.find(MasterCorporal.class, (Object)masterCorporalId);
        AdvancedCompositePKJunitTest.assertTrue((String)"The master corporal read back did not match the original", (boolean)AdvancedCompositePKJunitTest.getServerSession().compareObjects((Object)masterCorporal, (Object)refreshedMasterCorporal));
    }

    public void testMapsIdExample1b() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Sargeant sargeant = new Sargeant();
        MasterCorporal masterCorporal = new MasterCorporal();
        try {
            sargeant.setName("SargeB");
            masterCorporal.setSargeant(sargeant);
            em.persist((Object)masterCorporal);
            masterCorporal.getId().setName("CorpieB");
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.clearCache();
        em = this.createEntityManager();
        Sargeant refreshedSargeant = (Sargeant)em.find(Sargeant.class, (Object)sargeant.getSargeantId());
        AdvancedCompositePKJunitTest.assertTrue((String)"The sargeant read back did not match the original", (boolean)AdvancedCompositePKJunitTest.getServerSession().compareObjects((Object)sargeant, (Object)refreshedSargeant));
        MasterCorporal refreshedMasterCorporal = (MasterCorporal)em.find(MasterCorporal.class, (Object)masterCorporal.getId());
        AdvancedCompositePKJunitTest.assertTrue((String)"The master corporal read back did not match the original", (boolean)AdvancedCompositePKJunitTest.getServerSession().compareObjects((Object)masterCorporal, (Object)refreshedMasterCorporal));
    }

    public void testMapsIdExample2() {
        MajorId majorId;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Major major = new Major();
        Captain captain = new Captain();
        CaptainId captainId = new CaptainId();
        try {
            major.setFirstName("Mr.");
            major.setLastName("Major");
            majorId = major.getPK();
            em.persist((Object)major);
            captainId.setName("Captain Sparrow");
            captain.setId(captainId);
            captain.setMajor(major);
            em.persist((Object)captain);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.clearCache();
        em = this.createEntityManager();
        Major refreshedMajor = (Major)em.find(Major.class, (Object)majorId);
        AdvancedCompositePKJunitTest.assertTrue((String)"The major read back did not match the original", (boolean)AdvancedCompositePKJunitTest.getServerSession().compareObjects((Object)major, (Object)refreshedMajor));
        Captain refreshedCaptain = (Captain)em.find(Captain.class, (Object)captainId);
        AdvancedCompositePKJunitTest.assertTrue((String)"The captain read back did not match the original", (boolean)AdvancedCompositePKJunitTest.getServerSession().compareObjects((Object)captain, (Object)refreshedCaptain));
    }

    public void testMapsIdExample3() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Corporal corporal = new Corporal();
        CorporalId corporalId = new CorporalId();
        Private aPrivate = new Private();
        PrivateId privateId = new PrivateId();
        try {
            corporalId.setFirstName("Corporal");
            corporalId.setLastName("Kenny");
            corporal.setCorporalId(corporalId);
            em.persist((Object)corporal);
            privateId.setName("Private Ryan");
            aPrivate.setId(privateId);
            aPrivate.setCorporal(corporal);
            em.persist((Object)aPrivate);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.clearCache();
        em = this.createEntityManager();
        Corporal refreshedCorporal = (Corporal)em.find(Corporal.class, (Object)corporalId);
        AdvancedCompositePKJunitTest.assertTrue((String)"The corporal read back did not match the original", (boolean)AdvancedCompositePKJunitTest.getServerSession().compareObjects((Object)corporal, (Object)refreshedCorporal));
        Private refreshedPrivate = (Private)em.find(Private.class, (Object)privateId);
        AdvancedCompositePKJunitTest.assertTrue((String)"The private read back did not match the original", (boolean)AdvancedCompositePKJunitTest.getServerSession().compareObjects((Object)aPrivate, (Object)refreshedPrivate));
    }

    public void testMapsIdExample4() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        General general = new General();
        LieutenantGeneral lieutenantGeneral = new LieutenantGeneral();
        try {
            em.persist((Object)general);
            lieutenantGeneral.setGeneral(general);
            em.persist((Object)lieutenantGeneral);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.clearCache();
        em = this.createEntityManager();
        General refreshedGeneral = (General)em.find(General.class, (Object)general.getGeneralId());
        AdvancedCompositePKJunitTest.assertTrue((String)"The general read back did not match the original", (boolean)AdvancedCompositePKJunitTest.getServerSession().compareObjects((Object)general, (Object)refreshedGeneral));
        LieutenantGeneral refreshedLieutenantGeneral = (LieutenantGeneral)em.find(LieutenantGeneral.class, (Object)lieutenantGeneral.getId());
        AdvancedCompositePKJunitTest.assertTrue((String)"The lieutenant general read back did not match the original", (boolean)AdvancedCompositePKJunitTest.getServerSession().compareObjects((Object)lieutenantGeneral, (Object)refreshedLieutenantGeneral));
    }

    public void testMapsIdExample5() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        MajorGeneral majorGeneral = new MajorGeneral();
        BrigadierGeneral brigadierGeneral = new BrigadierGeneral();
        try {
            majorGeneral.setFirstName("Major");
            majorGeneral.setLastName("Bilko");
            brigadierGeneral.setMajorGeneral(majorGeneral);
            em.persist((Object)brigadierGeneral);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.clearCache();
        em = this.createEntityManager();
        MajorGeneral refreshedMajorGeneral = (MajorGeneral)em.find(MajorGeneral.class, (Object)majorGeneral.getPK());
        AdvancedCompositePKJunitTest.assertTrue((String)"The major general read back did not match the original", (boolean)AdvancedCompositePKJunitTest.getServerSession().compareObjects((Object)majorGeneral, (Object)refreshedMajorGeneral));
        BrigadierGeneral refreshedBrigadierGeneral = (BrigadierGeneral)em.find(BrigadierGeneral.class, (Object)brigadierGeneral.getId());
        AdvancedCompositePKJunitTest.assertTrue((String)"The brigadier general read back did not match the original", (boolean)AdvancedCompositePKJunitTest.getServerSession().compareObjects((Object)brigadierGeneral, (Object)refreshedBrigadierGeneral));
    }

    public void testMapsIdExample5a() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Major major = new Major();
        major.setFirstName("Another");
        major.setLastName("Major");
        MajorId majorId = major.getPK();
        Lackey lackey = new Lackey();
        LackeyCrewMember lcm = new LackeyCrewMember();
        LackeyCrewMemberId lcmId = new LackeyCrewMemberId();
        lcm.setLackey(lackey);
        lcm.setRank(1);
        lcmId.setRank(1);
        lcmId.setMajorPK(majorId);
        try {
            em.persist((Object)major);
            lackey.setMajor(major);
            lackey.setName("Little");
            em.persist((Object)lackey);
            em.persist((Object)lcm);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.clearCache();
        em = this.createEntityManager();
        Major refreshedMajor = (Major)em.find(Major.class, (Object)majorId);
        AdvancedCompositePKJunitTest.assertTrue((String)"The major read back did not match the original", (boolean)AdvancedCompositePKJunitTest.getServerSession().compareObjects((Object)major, (Object)refreshedMajor));
        Lackey refreshedLackey = (Lackey)em.find(Lackey.class, (Object)majorId);
        AdvancedCompositePKJunitTest.assertTrue((String)"The Lackey read back did not match the original", (boolean)AdvancedCompositePKJunitTest.getServerSession().compareObjects((Object)lackey, (Object)refreshedLackey));
        LackeyCrewMember refreshedLCM = (LackeyCrewMember)em.find(LackeyCrewMember.class, (Object)lcmId);
        AdvancedCompositePKJunitTest.assertTrue((String)"The LackeyCrewMember read back did not match the original", (boolean)AdvancedCompositePKJunitTest.getServerSession().compareObjects((Object)lcm, (Object)refreshedLCM));
    }

    public void testMapsIdExample6() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Lieutenant lieutenant = new Lieutenant();
        LieutenantId lieutenantId = new LieutenantId();
        SecondLieutenant secondLieutenant = new SecondLieutenant();
        try {
            lieutenantId.setFirstName("Lieutenant");
            lieutenantId.setLastName("Dan");
            lieutenant.setId(lieutenantId);
            em.persist((Object)lieutenant);
            em.persist((Object)secondLieutenant);
            secondLieutenant.setLieutenant(lieutenant);
            em.flush();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.clearCache();
        em = this.createEntityManager();
        Lieutenant refreshedLieutenant = (Lieutenant)em.find(Lieutenant.class, (Object)lieutenant.getId());
        AdvancedCompositePKJunitTest.assertTrue((String)"The lieutenant read back did not match the original", (boolean)AdvancedCompositePKJunitTest.getServerSession().compareObjects((Object)lieutenant, (Object)refreshedLieutenant));
        SecondLieutenant refreshedSecondLieutenant = (SecondLieutenant)em.find(SecondLieutenant.class, (Object)secondLieutenant.getId());
        AdvancedCompositePKJunitTest.assertTrue((String)"The second lieutenant read back did not match the original", (boolean)AdvancedCompositePKJunitTest.getServerSession().compareObjects((Object)secondLieutenant, (Object)refreshedSecondLieutenant));
    }

    public void testMapsIdExample6MultiLevel() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Lieutenant lieutenant = new Lieutenant();
        LieutenantId lieutenantId = new LieutenantId();
        SecondLieutenant secondLieutenant = new SecondLieutenant();
        OfficerCadet officerCadet = new OfficerCadet();
        try {
            lieutenantId.setFirstName("Lieutenant");
            lieutenantId.setLastName("Daniel");
            lieutenant.setId(lieutenantId);
            em.persist((Object)lieutenant);
            em.persist((Object)secondLieutenant);
            secondLieutenant.setLieutenant(lieutenant);
            officerCadet.setSecondLieutenant(secondLieutenant);
            em.persist((Object)officerCadet);
            em.flush();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.clearCache();
        em = this.createEntityManager();
        Lieutenant refreshedLieutenant = (Lieutenant)em.find(Lieutenant.class, (Object)lieutenant.getId());
        AdvancedCompositePKJunitTest.assertTrue((String)"The lieutenant read back did not match the original", (boolean)AdvancedCompositePKJunitTest.getServerSession().compareObjects((Object)lieutenant, (Object)refreshedLieutenant));
        SecondLieutenant refreshedSecondLieutenant = (SecondLieutenant)em.find(SecondLieutenant.class, (Object)secondLieutenant.getId());
        AdvancedCompositePKJunitTest.assertTrue((String)"The second lieutenant read back did not match the original", (boolean)AdvancedCompositePKJunitTest.getServerSession().compareObjects((Object)secondLieutenant, (Object)refreshedSecondLieutenant));
        OfficerCadet refreshedOfficerCadet = (OfficerCadet)em.find(OfficerCadet.class, (Object)officerCadet.getId());
        AdvancedCompositePKJunitTest.assertTrue((String)"The officer cadet read back did not match the original", (boolean)AdvancedCompositePKJunitTest.getServerSession().compareObjects((Object)officerCadet, (Object)refreshedOfficerCadet));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetIdentifier() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            DepartmentPK pk = new DepartmentPK("DEPT B", "ROLE B", "LOCATION B");
            Department department = new Department();
            department.setName("DEPT B");
            department.setRole("ROLE B");
            department.setLocation("LOCATION B");
            em.persist((Object)department);
            em.flush();
            PersistenceUnitUtil util = emf.getPersistenceUnitUtil();
            AdvancedCompositePKJunitTest.assertTrue((String)"Got an incorrect id from persistenceUtil.getIdentifier()", (boolean)pk.equals(util.getIdentifier((Object)department)));
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJoinColumnSharesPK() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        ClassDescriptor descriptor = AdvancedCompositePKJunitTest.getServerSession().getDescriptor(Office.class);
        try {
            Department department = new Department();
            department.setName("DEPT B");
            department.setRole("ROLE B");
            department.setLocation("LOCATION B");
            em.persist((Object)department);
            Office office = new Office();
            office.setId(1);
            office.setLocation("LOCATION B");
            office.setDepartment(department);
            em.persist((Object)office);
            department.getOffices().add(office);
            em.flush();
            this.clearCache();
            office = (Office)em.find(Office.class, (Object)new OfficePK(1, "LOCATION B"));
            department = (Department)em.find(Department.class, (Object)new DepartmentPK("DEPT B", "ROLE B", "LOCATION B"));
            AdvancedCompositePKJunitTest.assertTrue((String)"Office's department not properly persisted", (office.getDepartment() != null ? 1 : 0) != 0);
            AdvancedCompositePKJunitTest.assertTrue((String)"Department's offices not properly persisted", (department.getOffices().size() > 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            AdvancedCompositePKJunitTest.fail((String)("Exception thrown while inserting an object with a read-only column in a foreign key." + e));
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMapWithDerivedId() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee emp = new Employee();
            emp.setFirstName("George");
            em.persist((Object)emp);
            Administrator adminEmp = new Administrator();
            adminEmp.setContractCompany("George's consulting");
            adminEmp.setEmployee(emp);
            em.persist((Object)adminEmp);
            Department support = new Department();
            support.setLocation("Ottawa");
            support.setName("Support");
            support.setRole("Support Customers");
            em.persist((Object)support);
            DepartmentAdminRole depAdmin = new DepartmentAdminRole();
            depAdmin.setAdmin(adminEmp);
            depAdmin.setDepartment(support);
            em.persist((Object)depAdmin);
            AdminPool pool = new AdminPool();
            pool.setId(1);
            pool.addAdmin(depAdmin);
            depAdmin.setPool(pool);
            em.persist((Object)pool);
            em.flush();
            em.clear();
            this.clearCache();
            pool = (AdminPool)em.find(AdminPool.class, (Object)pool.getId());
            AdvancedCompositePKJunitTest.assertTrue((String)"The AdminPool was not found.", (pool != null ? 1 : 0) != 0);
            AdvancedCompositePKJunitTest.assertTrue((String)"The map did not contain the correct elements.", (pool.getAdmins().get(depAdmin.buildDepartmentAdminRolePK()) != null ? 1 : 0) != 0);
        }
        catch (Exception e) {
            AdvancedCompositePKJunitTest.fail((String)("Exception caught while testing maps with derived ids." + e));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    public void testIdentitySequencingForDerivedId() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Bookie bookie = new Bookie();
        try {
            bookie.setName("Bookie Joe");
            CellNumber cellNumber1 = new CellNumber();
            cellNumber1.setNumber("613-765-6452");
            cellNumber1.setDescription("NHL bets");
            bookie.addCellNumber(cellNumber1);
            CellNumber cellNumber2 = new CellNumber();
            cellNumber2.setNumber("613-765-6222");
            cellNumber2.setDescription("NB@ bets");
            bookie.addCellNumber(cellNumber2);
            em.persist((Object)bookie);
            em.flush();
            CellNumber cellNumber3 = new CellNumber();
            cellNumber3.setNumber("613-765-7422");
            cellNumber3.setDescription("PGA bets");
            bookie.addCellNumber(cellNumber3);
            em.persist((Object)cellNumber3);
            em.flush();
            bookie.setName("Bookie Jo");
            cellNumber2.setDescription("NBA bets");
            em.flush();
            CellNumber findCellNumber1 = (CellNumber)em.find(CellNumber.class, (Object)cellNumber1.buildPK());
            AdvancedCompositePKJunitTest.assertNotNull((Object)findCellNumber1);
            CellNumberPK key = cellNumber2.buildPK();
            CellNumber findCellNumber2 = (CellNumber)em.find(CellNumber.class, (Object)key);
            AdvancedCompositePKJunitTest.assertNotNull((Object)findCellNumber2);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testSharedDerivedIdEmbeddableClass() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        MasterCorporalClone masterCorporal = new MasterCorporalClone();
        try {
            MasterCorporalId masterCorporalId = new MasterCorporalId();
            masterCorporalId.setName("MCC " + System.currentTimeMillis());
            masterCorporalId.setSargeantPK(System.currentTimeMillis());
            masterCorporal.setId(masterCorporalId);
            em.persist((Object)masterCorporal);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.clearCache();
        em = this.createEntityManager();
        MasterCorporalClone refreshedMasterCorporal = (MasterCorporalClone)em.find(MasterCorporalClone.class, (Object)masterCorporal.getId());
        AdvancedCompositePKJunitTest.assertTrue((String)"The master corporal clone read back did not match the original", (boolean)AdvancedCompositePKJunitTest.getServerSession().compareObjects((Object)masterCorporal, (Object)refreshedMasterCorporal));
    }

    public void testNestedMapsId() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            GolfClubHead head = new GolfClubHead();
            em.persist((Object)head);
            GolfClubShaft shaft = new GolfClubShaft();
            em.persist((Object)shaft);
            GolfClub golfClub = new GolfClub();
            golfClub.setHead(head);
            golfClub.setShaft(shaft);
            GolfClubOrder golfClubOrder = new GolfClubOrder();
            golfClubOrder.setGolfClub(golfClub);
            golfClub.setOrder(golfClubOrder);
            em.persist((Object)golfClub);
            em.persist((Object)golfClubOrder);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testCopyAggregateCollection() {
        Department department = new Department();
        department.setName("DEPT AggregateCollection");
        department.setRole("ROLE AggregateCollection");
        department.setLocation("LOCATION AggregateCollection");
        Competency competency = new Competency();
        competency.description = "Manage groups";
        competency.rating = 9;
        department.addCompetency(competency);
        EntityManager em = this.createEntityManager();
        CopyGroup privatelyOwned = new CopyGroup();
        Department departmentCopy = (Department)JpaHelper.getEntityManager((EntityManager)em).copy((Object)department, (AttributeGroup)privatelyOwned);
        if (departmentCopy.getCompetencies().size() != department.getCompetencies().size()) {
            AdvancedCompositePKJunitTest.fail((String)("departmentCopy.getCompetencies().size() = " + departmentCopy.getCompetencies().size() + "; " + department.getCompetencies().size() + " was expected"));
        }
        if (departmentCopy.getCompetencies() == department.getCompetencies()) {
            AdvancedCompositePKJunitTest.fail((String)"departmentCopy.getCompetencies() == department.getCompetencies()");
        }
        Competency copmetencyCopy = (Competency)departmentCopy.getCompetencies().iterator().next();
        if (!competency.description.equals(copmetencyCopy.description)) {
            AdvancedCompositePKJunitTest.fail((String)("competency.descripton = " + competency.description + "; but copmetencyCopy.description = " + copmetencyCopy.description));
        }
    }

    public void testFailedGetIdenitifier() {
        EntityManagerFactory factory = this.getEntityManagerFactory();
        Cubicle cube = new Cubicle();
        cube.setId(1);
        cube.setCode("a");
        try {
            factory.getPersistenceUnitUtil().getIdentifier((Object)cube);
        }
        catch (PersistenceException e) {
            return;
        }
        AdvancedCompositePKJunitTest.fail((String)"Exception not thrown for call to getIdentifier when empty constructor not available.");
    }

    public void testGetIdenitifierOnNonEntity() {
        EntityManagerFactory factory = this.getEntityManagerFactory();
        Object nonEntity = new Object();
        try {
            factory.getPersistenceUnitUtil().getIdentifier(nonEntity);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        AdvancedCompositePKJunitTest.fail((String)"IllegalArgumentException not thrown for call to getIdentifier with a non-entity class.");
    }

    public void testNestedEmbeddableSequenceGeneration() {
        if (!this.supportsSequenceObjects()) {
            return;
        }
        Book b = new Book("Book1");
        Author a = new Author("Author1");
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        b = (Book)em.merge((Object)b);
        a = (Author)em.merge((Object)a);
        AdvancedCompositePKJunitTest.assertTrue((String)("The PK value for " + b.getClass() + " (" + b.getId().getNumberId().getValue() + ") is not sequence generated"), (b.getId().getNumberId().getValue() >= Long.valueOf(1000L) ? 1 : 0) != 0);
        AdvancedCompositePKJunitTest.assertTrue((String)("The PK value for " + a.getClass() + " (" + a.getId().getNumberId().getValue() + ") is not sequence generated"), (a.getId().getNumberId().getValue() >= Long.valueOf(1000L) ? 1 : 0) != 0);
        this.rollbackTransaction(em);
    }
}

