/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.embeddable.Continent;
import org.eclipse.persistence.testing.models.jpa.advanced.embeddable.Country;
import org.eclipse.persistence.testing.models.jpa.advanced.embeddable.Description;
import org.eclipse.persistence.testing.models.jpa.advanced.embeddable.Visitor;
import org.eclipse.persistence.testing.models.jpa.advanced.embeddable.VisitorPopulator;

public class EntityEmbeddableTest
extends JUnitTestCase {
    protected String PUName = "embeddable";

    public EntityEmbeddableTest() {
        this.setPuName(this.PUName);
    }

    public EntityEmbeddableTest(String name) {
        super(name);
        this.setPuName(this.PUName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new EntityEmbeddableTest("testSetup"));
        return EntityEmbeddableTest.addEntityEmbeddableTest(suite);
    }

    public static Test addEntityEmbeddableTest(TestSuite suite) {
        suite.setName("EntityEmbeddableTest");
        suite.addTest((Test)new EntityEmbeddableTest("testNativeQueryWithSqlResultSetMappings"));
        suite.addTest((Test)new EntityEmbeddableTest("testRootEmbeddable"));
        suite.addTest((Test)new EntityEmbeddableTest("testNestedEmbeddable"));
        suite.addTest((Test)new EntityEmbeddableTest("testMixedEmbeddable"));
        return suite;
    }

    public void testSetup() {
        System.out.println("testSetup");
        new AdvancedTableCreator().replaceTables((DatabaseSession)EntityEmbeddableTest.getServerSession((String)this.PUName));
        EntityEmbeddableTest.clearCache((String)this.PUName);
    }

    private Collection<Visitor> createVisitorEntities(EntityManager em) {
        LinkedList<Visitor> visitors = new LinkedList<Visitor>();
        this.beginTransaction(em);
        try {
            Visitor v1 = VisitorPopulator.visitorExample1();
            Visitor v2 = VisitorPopulator.visitorExample2();
            em.persist((Object)v1);
            em.persist((Object)v2);
            visitors.add(v1);
            visitors.add(v2);
        }
        catch (RuntimeException ex) {
            this.rollbackTransaction(em);
            throw ex;
        }
        em.flush();
        this.commitTransaction(em);
        return visitors;
    }

    private void deleteVisitorEntities(EntityManager em, Collection<Visitor> visitors) {
        this.beginTransaction(em);
        try {
            for (Visitor visitor : visitors) {
                em.remove((Object)visitor);
            }
        }
        catch (RuntimeException ex) {
            this.rollbackTransaction(em);
            throw ex;
        }
        em.flush();
        this.commitTransaction(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNativeQueryWithSqlResultSetMappings() {
        boolean passCounter = false;
        EntityManager em = EntityEmbeddableTest.createEntityManager((String)this.PUName);
        Collection<Visitor> visitors = null;
        try {
            visitors = this.createVisitorEntities(em);
            List q = em.createNativeQuery("Select o.ID AS OID, o.NAME AS ONAME, o.COUNTRY AS OCOUNTRY, o.CODE AS OCODE from CMP3_EMBED_VISITOR o WHERE (o.ID = '1')", "VisitorResults").getResultList();
            EntityEmbeddableTest.assertEquals((String)"Size of returned list with query results should be 1.", (int)q.size(), (int)1);
            for (Object obj : q) {
                if (obj instanceof Visitor) {
                    Visitor custReturned = (Visitor)obj;
                    EntityEmbeddableTest.assertTrue((String)"Visitor object primary key is invalid.", (boolean)"1".equals(custReturned.getId()));
                    EntityEmbeddableTest.assertTrue((String)"Country code is invalid.", (boolean)"USA".equals(custReturned.getCountry().getCode()));
                    continue;
                }
                EntityEmbeddableTest.fail((String)("Received unexpected instance: " + obj != null ? obj.getClass().getName() : "null"));
            }
        }
        catch (Exception e) {
            EntityEmbeddableTest.fail((String)("Unexpected exception occurred: " + e.getMessage()));
        }
        finally {
            if (visitors != null) {
                this.deleteVisitorEntities(em, visitors);
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRootEmbeddable() {
        EntityManager em = EntityEmbeddableTest.createEntityManager((String)this.PUName);
        this.beginTransaction(em);
        Visitor v = null;
        try {
            v = VisitorPopulator.visitorExample3();
            em.persist((Object)v);
            em.flush();
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            this.rollbackTransaction(em);
            throw ex;
        }
        this.beginTransaction(em);
        try {
            v.setName("fixed name");
            em.merge((Object)v);
            em.flush();
            v.setCountry(null);
            em.merge((Object)v);
            em.flush();
            v.setCountry(new Country("HU", "Hungary", "EUR"));
            v.getCountry().setCode("OTH");
            em.merge((Object)v);
            em.flush();
            v.getCountry().setCode(null);
            em.merge((Object)v);
            em.flush();
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNestedEmbeddable() {
        EntityManager em = EntityEmbeddableTest.createEntityManager((String)this.PUName);
        this.beginTransaction(em);
        Visitor v = null;
        try {
            v = VisitorPopulator.visitorExample4();
            em.persist((Object)v);
            em.flush();
            v.getCountry().setContinent(null);
            em.merge((Object)v);
            em.flush();
            Continent c = new Continent("Africa");
            v.getCountry().setContinent(c);
            em.merge((Object)v);
            em.flush();
            v.getCountry().setContinent(new Continent("AFR"));
            em.merge((Object)v);
            em.flush();
            v.getCountry().setContinent(null);
            em.merge((Object)v);
            em.flush();
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMixedEmbeddable() {
        EntityManager em = EntityEmbeddableTest.createEntityManager((String)this.PUName);
        this.beginTransaction(em);
        Visitor v = null;
        try {
            v = VisitorPopulator.visitorExample5();
            em.persist((Object)v);
            em.flush();
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            this.rollbackTransaction(em);
            throw ex;
        }
        this.beginTransaction(em);
        try {
            v.getCountry().getContinent().setDescription(null);
            em.merge((Object)v);
            em.flush();
            v.getCountry().setContinent(null);
            em.merge((Object)v);
            em.flush();
            v.setCountry(null);
            em.merge((Object)v);
            em.flush();
            v.setCountry(new Country("JAR", "South Africa", "EUR"));
            Continent c = new Continent("Africa");
            v.getCountry().setContinent(c);
            em.merge((Object)v);
            em.flush();
            v.getCountry().getContinent().setContinentCode("AFR");
            em.merge((Object)v);
            em.flush();
            v.getCountry().getContinent().setDescription(new Description("Africa is nice continent"));
            em.merge((Object)v);
            em.flush();
            v.getCountry().getContinent().setDescription(null);
            em.merge((Object)v);
            em.flush();
            v.getCountry().setContinent(null);
            em.merge((Object)v);
            em.flush();
            v.setCountry(null);
            em.merge((Object)v);
            em.flush();
            v.setCountry(new Country("ALB", "ALBANIA", "EUR"));
            v.getCountry().getContinent().setDescription(new Description("Small continent"));
            em.merge((Object)v);
            em.flush();
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
    }
}

