/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.util.List;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.PropertiesUtil;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.AbstractConsumerContainerSelector;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IConsumerContainerSelector;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.SelectContainerException;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;

public class ConsumerContainerSelector
extends AbstractConsumerContainerSelector
implements IConsumerContainerSelector {
    private static final boolean reuseExistingContainers = new Boolean(System.getProperty("org.eclipse.ecf.osgi.services.remoteserviceadmin.ConsumerContainerSelector.reuseExistingContainers", "true"));
    private boolean autoCreateContainer = false;

    public ConsumerContainerSelector(boolean autoCreateContainer) {
        this.autoCreateContainer = autoCreateContainer;
    }

    public IRemoteServiceContainer selectConsumerContainer(EndpointDescription endpointDescription) throws SelectContainerException {
        IRemoteServiceContainer rsContainer;
        this.trace("selectConsumerContainers", "endpointDescription=" + (Object)((Object)endpointDescription));
        List sic = PropertiesUtil.getStringPlusProperty(endpointDescription.getProperties(), "service.imported.configs");
        String[] serviceImportedConfigs = sic.toArray(new String[sic.size()]);
        ID endpointContainerID = endpointDescription.getContainerID();
        ID connectTargetID = endpointDescription.getConnectTargetID();
        IRemoteServiceContainer iRemoteServiceContainer = rsContainer = reuseExistingContainers ? this.selectExistingConsumerContainer(endpointContainerID, serviceImportedConfigs, connectTargetID) : null;
        if (rsContainer == null && this.autoCreateContainer) {
            rsContainer = this.createAndConfigureConsumerContainer(serviceImportedConfigs, endpointDescription.getProperties());
        }
        this.connectContainerToTarget(rsContainer, connectTargetID);
        return rsContainer;
    }

    public void close() {
    }
}

