/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.storage.sesame.storage.helpers;

import com.google.common.collect.HashMultimap;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.polarsys.reqcycle.traceability.engine.ITraceabilityEngine;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.model.LinkState;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.helpers.ReachablesStorageHelper;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.helpers.StorageHelpersProvider;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.internal.beans.LinkRef;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.rdf.Queries;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.rdf.ReqVoc;
import org.polarsys.reqcycle.uri.model.Reachable;

public class LinksStorageHelper {
    private final RepositoryConnection conn;
    private final ValueFactory valueFactory;
    private final StorageHelpersProvider helpers;

    LinksStorageHelper(RepositoryConnection conn, StorageHelpersProvider storageHelpersProvider) {
        this.conn = conn;
        this.valueFactory = conn.getValueFactory();
        this.helpers = storageHelpersProvider;
    }

    public static URI getDirectionPredicate(ITraceabilityEngine.DIRECTION direction) {
        Object extremityPredicate = direction == ITraceabilityEngine.DIRECTION.UPWARD ? ReqVoc.HAS_DOWNSTREAM : (direction == ITraceabilityEngine.DIRECTION.DOWNWARD ? ReqVoc.HAS_UPSTREAM : null);
        return extremityPredicate;
    }

    public URI storeLink(Reachable traceability, TType ttype, Reachable downstream, Reachable[] upstreams, Reachable container) throws RepositoryException, URISyntaxException {
        Resource[] contexts;
        ReachablesStorageHelper reachablesStorageHelper = this.helpers.getReachablesStorageHelper();
        Reachable kind = this.helpers.getKindsStorageHelper().toReachable(ttype);
        if (container != null) {
            URI contextUri = ReachablesStorageHelper.getURI(container);
            contexts = new Resource[]{contextUri};
        } else {
            contexts = new Resource[]{};
        }
        URI sourceUri = reachablesStorageHelper.storeReachable(downstream, ReqVoc.TYPE_TRACEABLE, contexts);
        URI linkUri = reachablesStorageHelper.storeReachable(traceability, ReqVoc.TYPE_TRACEABILITY, contexts);
        URI kindUri = reachablesStorageHelper.storeReachable(kind, ReqVoc.TYPE_TTYPE, contexts);
        this.conn.add((Resource)linkUri, ReqVoc.HAS_DOWNSTREAM, (Value)sourceUri, contexts);
        this.conn.add((Resource)linkUri, ReqVoc.HAS_KIND, (Value)kindUri, contexts);
        Reachable[] reachableArray = upstreams;
        int n = upstreams.length;
        int n2 = 0;
        while (n2 < n) {
            Reachable upstream = reachableArray[n2];
            URI targetUri = reachablesStorageHelper.storeReachable(upstream, ReqVoc.TYPE_TRACEABLE, contexts);
            this.conn.add((Resource)linkUri, ReqVoc.HAS_UPSTREAM, (Value)targetUri, contexts);
            ++n2;
        }
        return linkUri;
    }

    public Collection<LinkRef> getStoredLinkRefsByExtremity(URI direction, URI extremity, Resource context) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        String queryString = Queries.buildLinkSelectQuery(context);
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        if (direction != null) {
            query.setBinding("direction", (Value)direction);
        }
        if (extremity != null) {
            query.setBinding("extremity", (Value)extremity);
        }
        TupleQueryResult result = query.evaluate();
        HashSet<LinkRef> list = new HashSet<LinkRef>();
        while (result.hasNext()) {
            BindingSet binding = (BindingSet)result.next();
            Value link = binding.getValue("link");
            Value kind = binding.getValue("kind");
            Value directionValue = binding.getValue("direction");
            if (link == null || kind == null) continue;
            URI linkURI = this.valueFactory.createURI(link.stringValue());
            URI kindURI = this.valueFactory.createURI(kind.stringValue());
            ITraceabilityEngine.DIRECTION linkDirection = ReqVoc.HAS_DOWNSTREAM.equals((Object)directionValue) ? ITraceabilityEngine.DIRECTION.UPWARD : ITraceabilityEngine.DIRECTION.DOWNWARD;
            list.add(new LinkRef(linkURI, kindURI, linkDirection));
        }
        return list;
    }

    public Collection<URI> getStoredLinkExtremities(URI direction, URI link, Resource context) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        String queryString = Queries.buildLinkSelectQuery(context);
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        if (link != null) {
            query.setBinding("link", (Value)link);
        }
        if (direction != null) {
            query.setBinding("direction", (Value)direction);
        }
        TupleQueryResult result = query.evaluate();
        LinkedList<URI> list = new LinkedList<URI>();
        while (result.hasNext()) {
            BindingSet binding = (BindingSet)result.next();
            Value element = binding.getValue("extremity");
            if (element == null) continue;
            URI elementURI = this.valueFactory.createURI(element.stringValue());
            list.add(elementURI);
        }
        return list;
    }

    public Link getStoredLinkFromRef(LinkRef linkRef, Resource context) throws RepositoryException, MalformedQueryException, QueryEvaluationException, URISyntaxException {
        LinkedList<Reachable> targets;
        LinkedList<Reachable> sources;
        URI linkUri = linkRef.getId();
        URI kindUri = linkRef.getKind();
        Reachable linkReachable = this.helpers.getReachablesStorageHelper().getStoredReachable(this.conn, linkUri, context);
        Reachable kindReachable = this.helpers.getReachablesStorageHelper().getStoredReachable(this.conn, kindUri, context);
        TType kind = this.helpers.getKindsStorageHelper().toTType(kindReachable);
        Collection<URI> downstreamsUris = this.getStoredLinkExtremities(ReqVoc.HAS_DOWNSTREAM, linkUri, context);
        LinkedList<Reachable> downstreams = new LinkedList<Reachable>();
        for (URI uri : downstreamsUris) {
            Reachable reachable = this.helpers.getReachablesStorageHelper().getStoredReachable(this.conn, uri, context);
            downstreams.add(reachable);
        }
        Collection<URI> upstreamsUris = this.getStoredLinkExtremities(ReqVoc.HAS_UPSTREAM, linkUri, context);
        LinkedList<Reachable> upstreams = new LinkedList<Reachable>();
        for (URI uri : upstreamsUris) {
            Reachable reachable = this.helpers.getReachablesStorageHelper().getStoredReachable(this.conn, uri, context);
            upstreams.add(reachable);
        }
        if (linkRef.getDirection() == ITraceabilityEngine.DIRECTION.UPWARD) {
            sources = downstreams;
            targets = upstreams;
        } else {
            sources = upstreams;
            targets = downstreams;
        }
        long creationDate = 0L;
        String value = (String)linkReachable.getProperties().get("org.polarsys.reqcycle.traceability.creationDate");
        if (value != null) {
            creationDate = Long.valueOf(value);
        }
        long lastModificationDate = 0L;
        value = (String)linkReachable.getProperties().get("org.polarsys.reqcycle.traceability.lastModificationDate");
        if (value != null) {
            lastModificationDate = Long.valueOf(value);
        }
        LinkState state = LinkState.VALIDATED;
        value = (String)linkReachable.getProperties().get("org.polarsys.reqcycle.traceability.lifecycle");
        if (value != null) {
            state = Link.getLinkStateFromString((String)value);
        }
        SortedMap changeHistory = new TreeMap();
        value = (String)linkReachable.getProperties().get("org.polarsys.reqcycle.traceability.changeHistory");
        if (value != null) {
            changeHistory = Link.getHistoryFromString((String)value);
        }
        return new Link(linkReachable, creationDate, lastModificationDate, state, changeHistory, kind, sources, targets);
    }

    public void removeStoredLinks(URI kindUri, URI downwstreamUri, URI containerUri, Collection<Value> upstreams) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        String strquery = Queries.buildLinkSelectQuery2((Resource)containerUri);
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, strquery);
        if (kindUri != null) {
            query.setBinding("kind", (Value)kindUri);
        }
        if (downwstreamUri != null) {
            query.setBinding("source", (Value)downwstreamUri);
        }
        HashMultimap multimap = HashMultimap.create();
        TupleQueryResult queryResult = query.evaluate();
        while (queryResult.hasNext()) {
            BindingSet binding = (BindingSet)queryResult.next();
            Value linkValue = binding.getBinding("link").getValue();
            Value targetValue = binding.getBinding("target").getValue();
            multimap.put((Object)linkValue, (Object)targetValue);
        }
        for (Value linkValue : multimap.keySet()) {
            Collection linkedTargets = multimap.get((Object)linkValue);
            boolean allTargetShouldBeRemoved = upstreams.containsAll(linkedTargets);
            URI linkUri = this.valueFactory.createURI(linkValue.stringValue());
            if (allTargetShouldBeRemoved) {
                this.conn.remove((Resource)linkUri, null, null, new Resource[]{containerUri});
                continue;
            }
            for (Value targetValue : upstreams) {
                URI targetUri = this.valueFactory.createURI(targetValue.stringValue());
                this.conn.remove((Resource)linkUri, ReqVoc.HAS_UPSTREAM, (Value)targetUri, new Resource[]{containerUri});
            }
        }
    }
}

