/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.utils.modelnature.internal;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import javax.inject.Singleton;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.reqcycle.utils.modelnature.ModelNature;
import org.polarsys.reqcycle.utils.modelnature.ModelNatureService;
import org.polarsys.reqcycle.utils.modelnature.exceptions.NatureNotFoundException;

@Singleton
public class DynamicNatureServiceImpl
implements ModelNatureService {
    protected Multimap<String, String> natureMap = HashMultimap.create();

    @Override
    public void addNature(EModelElement eObject, String natureID) throws NatureNotFoundException {
        String fragment = EcoreUtil.getURI((EObject)eObject).fragment();
        if (!this.getModelNaturesIds().contains(natureID)) {
            throw new NatureNotFoundException(natureID);
        }
        this.natureMap.put((Object)fragment, (Object)natureID);
    }

    @Override
    public void removeNature(EModelElement eObject, String natureID) throws NatureNotFoundException {
        String fragment = EcoreUtil.getURI((EObject)eObject).fragment();
        this.natureMap.remove((Object)fragment, (Object)natureID);
    }

    @Override
    public boolean hasNature(EModelElement eObject, String natureID) {
        String fragment = EcoreUtil.getURI((EObject)eObject).fragment();
        if (!this.getModelNaturesIds().contains(natureID)) {
            return false;
        }
        Collection naturesOfEObject = this.natureMap.get((Object)fragment);
        return naturesOfEObject.contains(natureID);
    }

    @Override
    public Collection<ModelNature> getModelNatures() {
        return null;
    }

    @Override
    public Collection<String> getModelNaturesIds() {
        return null;
    }
}

