/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.uri.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.model.IHandler;
import org.polarsys.reqcycle.uri.model.IObjectHandler;
import org.polarsys.reqcycle.uri.model.IReachableHandler;
import org.polarsys.reqcycle.uri.model.NullReachableObject;
import org.polarsys.reqcycle.uri.model.ProxyResolver;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

@Singleton
public class ReachableManager
implements IReachableManager {
    private static final CacheBuilder<Object, Object> BUILDER = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(15L, TimeUnit.MINUTES);
    private static String EXT_POINT_HANDLER = "reachableHandler";
    private static String OBJECT_HANDLER = "objectHandler";
    private static String REACH_HANDLER = EXT_POINT_HANDLER;
    private Map<IHandler, Integer> priorities = new HashMap<IHandler, Integer>();
    private static final Pattern numberPattern = Pattern.compile("\\d*");
    private List<IHandler> handlers = new ArrayList<IHandler>();
    IExtensionRegistry registry = Platform.getExtensionRegistry();
    Cache<Object, IObjectHandler> cacheObjects = BUILDER.build();
    Cache<Reachable, IReachableHandler> cacheReachables = BUILDER.build();

    @PostConstruct
    public void postConstruct() {
        IConfigurationElement[] iConfigurationElementArray = this.registry.getConfigurationElementsFor("org.polarsys.reqcycle.uri", EXT_POINT_HANDLER);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement i = iConfigurationElementArray[n2];
            try {
                IHandler toAdd = null;
                if (OBJECT_HANDLER.equals(i.getName())) {
                    toAdd = (IObjectHandler)i.createExecutableExtension("handler");
                } else if (REACH_HANDLER.equals(i.getName())) {
                    toAdd = (IReachableHandler)i.createExecutableExtension("handler");
                }
                if (toAdd != null) {
                    ZigguratInject.inject((Object[])new Object[]{toAdd});
                    String prio = i.getAttribute("priority");
                    Integer val = 0;
                    if (prio != null && numberPattern.matcher(prio).matches()) {
                        val = Integer.valueOf(prio);
                    }
                    this.priorities.put(toAdd, val);
                    this.handlers.add(toAdd);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        Collections.sort(this.handlers, new Comparator<IHandler>(){

            @Override
            public int compare(IHandler o1, IHandler o2) {
                Integer pval1 = (Integer)ReachableManager.this.priorities.get(o1);
                Integer pval2 = (Integer)ReachableManager.this.priorities.get(o2);
                Integer p1 = pval1 != null ? pval1 : 0;
                Integer p2 = pval2 != null ? pval2 : 0;
                return -p1.compareTo(p2);
            }
        });
    }

    @Override
    public IReachableHandler getHandlerFromReachable(final Reachable t) throws IReachableHandlerException {
        IReachableHandler get;
        if (t == null) {
            throw new IReachableHandlerException();
        }
        try {
            get = (IReachableHandler)this.cacheReachables.get((Object)t, (Callable)new Callable<IReachableHandler>(){

                @Override
                public IReachableHandler call() throws Exception {
                    for (IReachableHandler h : Iterables.filter((Iterable)ReachableManager.this.handlers, IReachableHandler.class)) {
                        if (!h.handlesReachable(t)) continue;
                        return ReachableManager.this.getProxy(h);
                    }
                    throw new Exception();
                }
            });
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            throw new IReachableHandlerException();
        }
        if (get == null) {
            throw new IReachableHandlerException();
        }
        return get;
    }

    private IReachableHandler getProxy(final IReachableHandler h) {
        return new CachedReachableHandler(new IReachableHandler(){

            @Override
            public boolean handlesReachable(Reachable t) {
                return h.handlesReachable(t);
            }

            @Override
            public ProxyResolver getProxyResolver() {
                return h.getProxyResolver();
            }

            @Override
            public ReachableObject getFromReachable(Reachable t) {
                ReachableObject object = h.getFromReachable(t);
                if (object != null) {
                    return object;
                }
                return new NullReachableObject();
            }
        });
    }

    private IObjectHandler getProxy(final IObjectHandler h) {
        return new CachedObjectHandler(new IObjectHandler(){

            @Override
            public boolean handlesObject(Object object) {
                return h.handlesObject(object);
            }

            @Override
            public ReachableObject getFromObject(Object object) {
                ReachableObject rObject = h.getFromObject(object);
                if (rObject == null) {
                    return new NullReachableObject();
                }
                return rObject;
            }
        });
    }

    @Override
    public IObjectHandler getHandlerFromObject(final Object o) throws IReachableHandlerException {
        IObjectHandler get;
        if (o == null) {
            throw new IReachableHandlerException();
        }
        try {
            get = (IObjectHandler)this.cacheObjects.get(o, (Callable)new Callable<IObjectHandler>(){

                @Override
                public IObjectHandler call() throws Exception {
                    for (IObjectHandler h : Iterables.filter((Iterable)ReachableManager.this.handlers, IObjectHandler.class)) {
                        if (!h.handlesObject(o)) continue;
                        return ReachableManager.this.getProxy(h);
                    }
                    throw new Exception();
                }
            });
        }
        catch (ExecutionException executionException) {
            throw new IReachableHandlerException();
        }
        if (get == null) {
            throw new IReachableHandlerException();
        }
        return get;
    }

    private static class CachedObjectHandler
    implements IObjectHandler {
        private Cache<Object, ReachableObject> cache = CacheBuilder.newBuilder().weakKeys().expireAfterWrite(5L, TimeUnit.MINUTES).build();
        private IObjectHandler handler;

        public CachedObjectHandler(IObjectHandler handler) {
            this.handler = handler;
        }

        @Override
        public ReachableObject getFromObject(final Object object) {
            try {
                if (object == null) {
                    return new NullReachableObject();
                }
                return (ReachableObject)this.cache.get(object, (Callable)new Callable<ReachableObject>(){

                    @Override
                    public ReachableObject call() throws Exception {
                        return CachedObjectHandler.this.handler.getFromObject(object);
                    }
                });
            }
            catch (ExecutionException executionException) {
                return this.handler.getFromObject(object);
            }
        }

        @Override
        public boolean handlesObject(Object object) {
            return this.handler.handlesObject(object);
        }
    }

    private static class CachedReachableHandler
    implements IReachableHandler {
        private Cache<Reachable, ReachableObject> cache = CacheBuilder.newBuilder().weakKeys().expireAfterWrite(10L, TimeUnit.MINUTES).build();
        private IReachableHandler handler;

        public CachedReachableHandler(IReachableHandler handler) {
            this.handler = handler;
        }

        @Override
        public ReachableObject getFromReachable(final Reachable t) {
            try {
                if (t == null) {
                    return new NullReachableObject();
                }
                return (ReachableObject)this.cache.get((Object)t, (Callable)new Callable<ReachableObject>(){

                    @Override
                    public ReachableObject call() throws Exception {
                        return CachedReachableHandler.this.handler.getFromReachable(t);
                    }
                });
            }
            catch (ExecutionException executionException) {
                System.out.println("could not find key for reachable " + t);
                return this.handler.getFromReachable(t);
            }
        }

        @Override
        public boolean handlesReachable(Reachable t) {
            return this.handler.handlesReachable(t);
        }

        @Override
        public ProxyResolver getProxyResolver() {
            return this.handler.getProxyResolver();
        }
    }
}

