/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.utils.iterators.pickers;

import org.polarsys.reqcycle.utils.iterators.exceptions.PickerExecutionException;
import org.polarsys.reqcycle.utils.iterators.handlers.PickingHandler;
import org.polarsys.reqcycle.utils.iterators.pickers.IPicker;

public abstract class ExecutivePicker
implements IPicker {
    protected IPicker basicPicker;

    public ExecutivePicker(IPicker picker) {
        this.basicPicker = picker;
    }

    @Override
    public Iterable<?> getNexts(Object element) throws PickerExecutionException {
        Iterable<?> nexts = this.basicPicker.getNexts(element);
        Iterable<PickingHandler> handlers = this.retrieveHandlers();
        if (handlers != null) {
            for (PickingHandler handler : handlers) {
                handler.performTreatment(this, element, nexts);
            }
        }
        return nexts;
    }

    protected abstract Iterable<PickingHandler> retrieveHandlers();
}

