/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.connector.document;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.polarsys.kitalpha.doc.doc2model.wordprocessor.wordprocessor.Section;
import org.polarsys.reqcycle.core.ILogger;
import org.polarsys.reqcycle.repository.connector.document.DocRequirementModele;
import org.polarsys.reqcycle.repository.connector.document.DocSectionModele;
import org.polarsys.reqcycle.repository.connector.document.LogUtils;
import org.polarsys.reqcycle.repository.connector.ui.PropertyUtils;
import org.polarsys.reqcycle.repository.data.IDataManager;
import org.polarsys.reqcycle.repository.data.MappingModel.MappingAttribute;
import org.polarsys.reqcycle.repository.data.MappingModel.MappingElement;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.AbstractElement;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Requirement;
import org.polarsys.reqcycle.repository.data.ScopeConf.Scope;
import org.polarsys.reqcycle.repository.data.types.IAttribute;
import org.polarsys.reqcycle.repository.data.types.IRequirementType;
import org.polarsys.reqcycle.repository.data.types.IType;
import org.polarsys.reqcycle.repository.data.types.internal.ETypeImpl;

public class DocParser {
    private StringBuffer document;
    private List<Section> sections;
    private HashMap<DocSectionModele, org.polarsys.reqcycle.repository.data.RequirementSourceData.Section> sectionMapping = new HashMap();
    @Inject
    ILogger logger;
    @Inject
    IDataManager manager;

    public void run(RequirementSource requirementSource) throws Exception {
        Scope scope = PropertyUtils.getScopeFromSource((RequirementSource)requirementSource);
        requirementSource.clearContent();
        ArrayList<DocRequirementModele> listReqModele = new ArrayList<DocRequirementModele>();
        ArrayList<DocSectionModele> listSectionModele = new ArrayList();
        String finalDoc = this.getFinalDocument();
        listSectionModele = this.createSections(requirementSource);
        if (listSectionModele != null) {
            Collections.sort(listSectionModele, new Comparator<DocSectionModele>(){

                @Override
                public int compare(DocSectionModele sec1, DocSectionModele sec2) {
                    return sec1.getPosition() < sec2.getPosition() ? -1 : (sec1.getPosition() > sec2.getPosition() ? 1 : 0);
                }
            });
            if (requirementSource.getMappings() != null) {
                for (MappingElement reqIn : requirementSource.getMappings()) {
                    Pattern pattern = Pattern.compile(reqIn.getSourceQualifier(), 40);
                    Matcher matcher = pattern.matcher(finalDoc);
                    while (matcher.find()) {
                        if (matcher.groupCount() > 0) {
                            if (LogUtils.isDebug()) {
                                System.out.println("req " + matcher.group(1) + " --- position : " + matcher.end());
                            }
                            listReqModele.add(new DocRequirementModele(matcher.end(), reqIn, matcher.group(1)));
                            continue;
                        }
                        if (LogUtils.isDebug()) {
                            LogUtils.log("req " + matcher.group() + " --- position : " + matcher.end());
                        }
                        listReqModele.add(new DocRequirementModele(matcher.end(), reqIn, matcher.group()));
                    }
                }
                if (listReqModele != null) {
                    Collections.sort(listReqModele, new Comparator<DocRequirementModele>(){

                        @Override
                        public int compare(DocRequirementModele req1, DocRequirementModele req2) {
                            return req1.getPosition() < req2.getPosition() ? -1 : (req1.getPosition() > req2.getPosition() ? 1 : 0);
                        }
                    });
                }
            }
        }
        int i = 0;
        while (i < listReqModele.size()) {
            IRequirementType requirementType = (IRequirementType)PropertyUtils.getDataModelFromSource((RequirementSource)requirementSource).getType(((DocRequirementModele)listReqModele.get(i)).getRequirement().getDescription());
            if (requirementType == null && LogUtils.isDebug()) {
                System.out.println("the requirementType " + requirementType + " is nul");
            }
            String startReq = ((DocRequirementModele)listReqModele.get(i)).getResult();
            String endReq = "\\Z";
            if (i + 1 < listReqModele.size()) {
                endReq = ((DocRequirementModele)listReqModele.get(i + 1)).getResult();
            }
            Pattern patternS = Pattern.compile("(" + startReq + ".*?)" + endReq, 40);
            Matcher matcherS = patternS.matcher(finalDoc);
            String documentSection = " ";
            while (matcherS.find()) {
                if (matcherS.groupCount() > 0) {
                    if (LogUtils.isDebug()) {
                        System.out.println("req " + matcherS.group(1) + " ------- position : " + matcherS.end());
                    }
                    documentSection = matcherS.group(1);
                    continue;
                }
                if (LogUtils.isDebug()) {
                    System.out.println("req " + matcherS.group() + " ------- position : " + matcherS.end());
                }
                documentSection = matcherS.group();
            }
            Pattern pattern = Pattern.compile(((DocRequirementModele)listReqModele.get(i)).getRequirement().getSourceQualifier(), 40);
            Matcher matcher = pattern.matcher(documentSection);
            while (matcher.find()) {
                Requirement requirement = requirementType.createInstance();
                if (matcher.groupCount() > 0) {
                    if (LogUtils.isDebug()) {
                        System.out.println(matcher.group(1));
                    }
                    requirement.setId(matcher.group(1));
                } else {
                    if (LogUtils.isDebug()) {
                        System.out.println(matcher.group());
                    }
                    requirement.setId(matcher.group());
                }
                requirement.getScopes().add((Object)scope);
                EList Attributes = ((DocRequirementModele)listReqModele.get(i)).getRequirement().getAttributes();
                for (final MappingAttribute att : Attributes) {
                    Pattern patternAtt = Pattern.compile(att.getSourceId(), 40);
                    Matcher matcherAtt = patternAtt.matcher(documentSection);
                    while (matcherAtt.find()) {
                        IAttribute attFromType = (IAttribute)Iterables.find((Iterable)requirementType.getAttributes(), (Predicate)new Predicate<IAttribute>(){

                            public boolean apply(IAttribute arg0) {
                                return arg0.getName().equals(att.getDescription());
                            }
                        }, null);
                        Object value = null;
                        if (attFromType == null) {
                            if (LogUtils.isDebug()) {
                                System.out.println("the attFromType " + attFromType + " is nul");
                            }
                        } else {
                            String stringFromDocument = null;
                            stringFromDocument = matcherAtt.groupCount() > 0 ? matcherAtt.group(1) : matcherAtt.group();
                            if (LogUtils.isDebug()) {
                                System.out.println("att : " + att.getDescription() + " :" + stringFromDocument);
                            }
                            value = this.getValueFromString(stringFromDocument, attFromType.getType());
                        }
                        this.manager.addAttributeValue((AbstractElement)requirement, attFromType, value);
                    }
                }
                org.polarsys.reqcycle.repository.data.RequirementSourceData.Section sect = this.findSectionForRequirement(((DocRequirementModele)listReqModele.get(i)).getPosition(), listSectionModele);
                this.manager.addElementsToSection(sect, new AbstractElement[]{requirement});
            }
            ++i;
        }
    }

    private String getFinalDocument() {
        Pattern pat;
        Matcher matcher;
        String doc = this.document.toString();
        String regex = "#start_exclusion.*?#end_exclusion";
        if (this.document != null && (matcher = (pat = Pattern.compile(regex, 40)).matcher(this.document)).find()) {
            doc = matcher.replaceAll(" ");
        }
        return doc;
    }

    private org.polarsys.reqcycle.repository.data.RequirementSourceData.Section findSectionForRequirement(int positionReq, List<DocSectionModele> listSectionModele) {
        int i = 0;
        while (i < listSectionModele.size()) {
            if (i + 1 == listSectionModele.size() ? listSectionModele.get(i).getPosition() <= positionReq : i + 1 < listSectionModele.size() && listSectionModele.get(i).getPosition() <= positionReq && positionReq < listSectionModele.get(i + 1).getPosition()) {
                return this.sectionMapping.get(listSectionModele.get(i));
            }
            ++i;
        }
        return null;
    }

    private Object getValueFromString(String stringFromDocument, IType attributeType) {
        if (attributeType.getName().equalsIgnoreCase(ETypeImpl.BOOLEAN.getName())) {
            return Boolean.valueOf(stringFromDocument);
        }
        if (attributeType.getName().equalsIgnoreCase(ETypeImpl.STRING.getName())) {
            return stringFromDocument;
        }
        if (attributeType.getName().equalsIgnoreCase(ETypeImpl.INT.getName())) {
            return Integer.valueOf(stringFromDocument);
        }
        return null;
    }

    private List<DocSectionModele> createSections(RequirementSource requirementSource) {
        ArrayList<DocSectionModele> listSections = new ArrayList<DocSectionModele>();
        for (Section sect : this.sections) {
            this.createHierarchieSections(requirementSource, listSections, sect);
        }
        return listSections;
    }

    private void createHierarchieSections(RequirementSource requirementSource, List<DocSectionModele> listSections, Section parentSection) {
        org.polarsys.reqcycle.repository.data.RequirementSourceData.Section sectionP = null;
        if (parentSection.getParent() == null) {
            Pattern patternP = Pattern.compile(parentSection.getTitle().getTextContent(), 40);
            Matcher matcherP = patternP.matcher(this.document);
            while (matcherP.find()) {
                String nameParentP = null;
                if (parentSection.getParent() != null && parentSection.getParent().getTitle() != null) {
                    nameParentP = parentSection.getParent().getTitle().getTextContent();
                }
                DocSectionModele sectionModeleP = new DocSectionModele(matcherP.group(), nameParentP, matcherP.end(), null);
                Boolean alredyInReqSrcP = false;
                for (DocSectionModele docs : listSections) {
                    if (!docs.getName().equals(sectionModeleP.getName()) || docs.getPosition() != sectionModeleP.getPosition()) continue;
                    alredyInReqSrcP = true;
                    break;
                }
                if (alredyInReqSrcP.booleanValue()) continue;
                if (LogUtils.isDebug()) {
                    System.out.println("non section " + matcherP.group() + " ------- position section: " + matcherP.end());
                }
                listSections.add(sectionModeleP);
                sectionP = this.manager.createSection(matcherP.group(), matcherP.group(), null);
                if (sectionP == null) continue;
                this.manager.addElementsToSource(requirementSource, new AbstractElement[]{sectionP});
                this.sectionMapping.put(sectionModeleP, sectionP);
            }
        }
        if (parentSection.getSections() != null) {
            this.createChildrenSections(listSections, parentSection, (AbstractElement)sectionP);
        }
    }

    private void createChildrenSections(List<DocSectionModele> listSections, Section parentSection, AbstractElement sectionP) {
        EList childrenSection = parentSection.getSections();
        for (Section sect : childrenSection) {
            Pattern pattern = Pattern.compile(sect.getTitle().getTextContent(), 40);
            Matcher matcher = pattern.matcher(this.document);
            org.polarsys.reqcycle.repository.data.RequirementSourceData.Section section = null;
            while (matcher.find()) {
                String nameParent = null;
                if (sect.getParent() != null && sect.getParent().getTitle() != null) {
                    nameParent = sect.getParent().getTitle().getTextContent();
                }
                DocSectionModele sectionModele = new DocSectionModele(matcher.group(), nameParent, matcher.end(), null);
                Boolean alredyInReqSrc = false;
                for (DocSectionModele docs : listSections) {
                    if (!docs.getName().equals(sectionModele.getName()) || docs.getPosition() != sectionModele.getPosition()) continue;
                    alredyInReqSrc = true;
                    break;
                }
                if (alredyInReqSrc.booleanValue()) continue;
                if (LogUtils.isDebug()) {
                    System.out.println("non section " + matcher.group() + " ------- position section: " + matcher.end());
                }
                listSections.add(sectionModele);
                section = this.manager.createSection(matcher.group(), matcher.group(), null);
                if (section == null) continue;
                this.manager.addElementsToSection((org.polarsys.reqcycle.repository.data.RequirementSourceData.Section)sectionP, new AbstractElement[]{section});
                this.sectionMapping.put(sectionModele, section);
            }
            if (sect.getSections() == null) continue;
            this.createChildrenSections(listSections, sect, (AbstractElement)section);
        }
    }

    public StringBuffer getDocument() {
        return this.document;
    }

    public void setDocument(StringBuffer document) {
        this.document = document;
    }

    public void setSections(List<Section> sections) {
        this.sections = sections;
    }

    public List<Section> getSections() {
        return this.sections;
    }
}

