/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.types.configuration.preferences.dialogs;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.inject.Inject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.reqcycle.traceability.types.ITraceTypesManager;
import org.polarsys.reqcycle.traceability.types.configuration.preferences.dialogs.AttributeComposite;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Attribute;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.RegisteredAttribute;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.StdAttribute;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.TypeConfigContainer;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.TypeconfigurationFactory;

public class NewAttributeDialog
extends TitleAreaDialog {
    private TypeConfigContainer container;
    @Inject
    ITraceTypesManager manager;
    private StdAttribute attribute;
    private Button btnNewAttribute;
    private Button btnRegisteredAttribute;
    private Group grpExistingAttribute;
    AttributeComposite registeredComposite;
    private ComboViewer comboViewer;
    private RegisteredAttribute NullRegistered = TypeconfigurationFactory.eINSTANCE.createRegisteredAttribute();

    public NewAttributeDialog(Shell parentShell, TypeConfigContainer container) {
        super(parentShell);
        this.setShellStyle(112);
        this.container = container;
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage("Attribute Creation");
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        Group grpTypeOfAttribute = new Group(container, 0);
        FillLayout fl_grpTypeOfAttribute = new FillLayout(512);
        fl_grpTypeOfAttribute.marginWidth = 5;
        fl_grpTypeOfAttribute.marginHeight = 5;
        grpTypeOfAttribute.setLayout((Layout)fl_grpTypeOfAttribute);
        grpTypeOfAttribute.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpTypeOfAttribute.setText("Type of attribute");
        this.btnNewAttribute = new Button((Composite)grpTypeOfAttribute, 16);
        this.btnNewAttribute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewAttributeDialog.this.setNewOne();
            }
        });
        this.btnNewAttribute.setSelection(true);
        this.btnNewAttribute.setText("New Attribute");
        this.btnRegisteredAttribute = new Button((Composite)grpTypeOfAttribute, 16);
        this.btnRegisteredAttribute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewAttributeDialog.this.setRegistered();
            }
        });
        this.btnRegisteredAttribute.setText("Registered Attribute");
        this.grpExistingAttribute = new Group(container, 0);
        this.grpExistingAttribute.setLayout((Layout)new GridLayout(2, false));
        this.grpExistingAttribute.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.grpExistingAttribute.setText("Attribute");
        Label lblNewLabel = new Label((Composite)this.grpExistingAttribute, 0);
        lblNewLabel.setBounds(0, 0, 55, 15);
        lblNewLabel.setText("id : ");
        this.comboViewer = new ComboViewer((Composite)this.grpExistingAttribute, 8);
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == NewAttributeDialog.this.NullRegistered) {
                    return "no registered attributes";
                }
                if (element instanceof RegisteredAttribute) {
                    RegisteredAttribute att = (RegisteredAttribute)element;
                    return String.valueOf(att.getName()) + " (" + att.getId() + ")";
                }
                return super.getText(element);
            }
        });
        this.comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        ArrayList newArrayList = Lists.newArrayList((Iterable)this.manager.getAllAttributes());
        if (newArrayList.isEmpty()) {
            newArrayList.add(this.NullRegistered);
        }
        this.comboViewer.setInput((Object)newArrayList);
        Combo combo = this.comboViewer.getCombo();
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewAttributeDialog.this.registeredComposite.displayAttribute((Attribute)((IStructuredSelection)NewAttributeDialog.this.comboViewer.getSelection()).getFirstElement());
            }
        });
        combo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        combo.setBounds(0, 0, 91, 23);
        this.registeredComposite = new AttributeComposite((Composite)this.grpExistingAttribute);
        this.registeredComposite.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this.registeredComposite.setEditable(false);
        this.setNewOne();
        this.recursiveSetEnabled((Control)container, true);
        return container;
    }

    public void recursiveSetEnabled(Control ctrl, boolean enabled) {
        if (ctrl instanceof Composite) {
            Composite comp = (Composite)ctrl;
            Control[] controlArray = comp.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                this.recursiveSetEnabled(c, enabled);
                c.setEnabled(enabled);
                ++n2;
            }
        } else {
            ctrl.setEnabled(enabled);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        okButton.setEnabled(true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(450, 491);
    }

    protected void okPressed() {
        if (this.btnRegisteredAttribute.getSelection()) {
            this.attribute = (StdAttribute)((IStructuredSelection)this.comboViewer.getSelection()).getFirstElement();
        } else {
            this.registeredComposite.saveInAttribute(this.attribute);
        }
        if (this.attribute == this.NullRegistered || this.attribute == null || this.attribute.getName() == null || this.attribute.getType() == null || !this.registeredComposite.isValid()) {
            this.setErrorMessage("Please verify your fields");
            return;
        }
        super.okPressed();
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public void setNewOne() {
        this.display(true);
        this.comboViewer.setSelection(null);
    }

    public void display(boolean newOne) {
        this.btnNewAttribute.setSelection(newOne);
        this.btnRegisteredAttribute.setSelection(!newOne);
        if (this.comboViewer.getCombo() != null) {
            this.comboViewer.getCombo().setEnabled(!newOne);
        }
        this.attribute = newOne ? TypeconfigurationFactory.eINSTANCE.createStdAttribute() : null;
        this.registeredComposite.setEditable(newOne);
    }

    public void setRegistered() {
        this.display(false);
    }
}

