/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.jdt.traceability;

import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.JavaModelException;
import org.polarsys.reqcycle.jdt.traceability.JDTPreferences;
import org.polarsys.reqcycle.traceability.builder.ITraceabilityBuilder;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.uri.ILogicalIDManager;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.visitors.IVisitor;

public class JDTTraceabilityVisitor
implements IVisitor {
    private IAdaptable adaptable;
    @Inject
    ILogicalIDManager manager;
    Map<String, TType> mapOfTypes = JDTPreferences.getPreferences();

    public void start(IAdaptable adaptable) {
    }

    public boolean visit(Object o, IAdaptable adaptable) {
        this.adaptable = adaptable;
        if (o instanceof IFile) {
            IFile file = (IFile)o;
            return file.getFileExtension().equalsIgnoreCase("java");
        }
        if (o instanceof IJavaElement && o instanceof IAnnotatable) {
            IAnnotatable annotable = (IAnnotatable)o;
            this.visit(annotable);
        }
        return true;
    }

    private void visit(IAnnotatable annot) {
        for (String s : this.mapOfTypes.keySet()) {
            IAnnotation ann = annot.getAnnotation(s);
            this.handleAnnot(annot, ann, this.mapOfTypes.get(s));
        }
    }

    protected void handleAnnot(IAnnotatable annot, IAnnotation ann, TType traceabilityLink) {
        if (ann != null) {
            try {
                IMemberValuePair[] pairs = ann.getMemberValuePairs();
                if (pairs != null) {
                    IMemberValuePair[] iMemberValuePairArray = pairs;
                    int n = pairs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMemberValuePair m = iMemberValuePairArray[n2];
                        if (m.getValue() instanceof String) {
                            Reachable reachable;
                            String value = (String)m.getValue();
                            if (annot instanceof IJavaElement && (reachable = this.manager.getReachable(value)) != null) {
                                this.getCallBack().newUpwardRelation((Object)((IJavaElement)annot).getElementName(), (Object)((IJavaElement)annot).getResource(), (Object)annot, Collections.singletonList(reachable), traceabilityLink);
                            }
                        }
                        ++n2;
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    public void end(IAdaptable adaptable) {
    }

    public ITraceabilityBuilder.IBuilderCallBack getCallBack() {
        return (ITraceabilityBuilder.IBuilderCallBack)this.adaptable.getAdapter(ITraceabilityBuilder.IBuilderCallBack.class);
    }
}

