/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.xcos.utils;

import com.google.common.base.Joiner;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.polarsys.reqcycle.uri.IReachableCreator;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;
import org.polarsys.reqcycle.xcos.model.XcosElement;
import org.polarsys.reqcycle.xcos.model.XcosReachableObject;

public class XcosUtils {
    public static final String XcosExtension = "xcos";
    public static final String PLATFORM = "platform:";
    public static final String SEPARATOR = "::";
    private static IReachableCreator creator = (IReachableCreator)ZigguratInject.make(IReachableCreator.class);

    public static ReachableObject getReachableObject(IFile cu) {
        if (XcosExtension.equalsIgnoreCase(cu.getFileExtension())) {
            try {
                XcosReachableObject xcosReachableObject = new XcosReachableObject(creator.getReachable(new URI(PLATFORM + cu.getFullPath().toString()), (Object)cu));
                ZigguratInject.inject((Object[])new Object[]{xcosReachableObject});
                return xcosReachableObject;
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static ReachableObject getReachable(XcosElement xe) {
        try {
            URI uri = new URI(XcosUtils.getQualifiedURI(xe));
            XcosReachableObject object = new XcosReachableObject(creator.getReachable(uri, (Object)xe));
            ZigguratInject.inject((Object[])new Object[]{object});
            return object;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static String getQualifiedURI(XcosElement element) {
        StringBuilder result = new StringBuilder();
        result.append(PLATFORM).append(element.getResource().getFullPath().toString()).append("#");
        LinkedList<String> names = new LinkedList<String>();
        names.add(element.getElementName());
        XcosElement parent = element.getParent();
        while (parent != null) {
            names.add(0, parent.getElementName());
            parent = parent.getParent();
        }
        result.append(Joiner.on((String)SEPARATOR).join(names));
        return result.toString();
    }
}

