/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javadocexport;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocExportMessages;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocOptionsManager;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocTreeWizardPage;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocWizardPage;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;

public class JavadocSpecificsWizardPage
extends JavadocWizardPage {
    private Button fAntBrowseButton;
    private Button fCheckbrowser;
    private Text fAntText;
    private Button fOverViewButton;
    private Button fOverViewBrowseButton;
    private Button fAntButton;
    private Composite fLowerComposite;
    private Text fOverViewText;
    private Text fExtraOptionsText;
    private Text fVMOptionsText;
    private StatusInfo fOverviewStatus;
    private StatusInfo fAntStatus;
    private JavadocTreeWizardPage fFirstPage;
    private JavadocOptionsManager fStore;
    private final int OVERVIEWSTATUS = 1;
    private final int ANTSTATUS = 2;

    protected JavadocSpecificsWizardPage(String pageName, JavadocTreeWizardPage firstPage, JavadocOptionsManager store) {
        super(pageName);
        this.setDescription(JavadocExportMessages.JavadocSpecificsWizardPage_description);
        this.fStore = store;
        this.fOverviewStatus = new StatusInfo();
        this.fAntStatus = new StatusInfo();
        this.fFirstPage = firstPage;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.fLowerComposite = new Composite(parent, 0);
        this.fLowerComposite.setLayoutData((Object)this.createGridData(1808, 1, 0));
        GridLayout layout = this.createGridLayout(3);
        layout.marginHeight = 0;
        this.fLowerComposite.setLayout((Layout)layout);
        this.createExtraOptionsGroup(this.fLowerComposite);
        this.createAntGroup(this.fLowerComposite);
        this.setControl((Control)this.fLowerComposite);
        Dialog.applyDialogFont((Control)this.fLowerComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fLowerComposite, "org.eclipse.wst.jsdt.ui.javadoc_specifics_page_context");
    }

    private void createExtraOptionsGroup(Composite composite) {
        Composite c = new Composite(composite, 0);
        c.setLayout((Layout)this.createGridLayout(3));
        c.setLayoutData((Object)this.createGridData(768, 3, 0));
        ((GridLayout)c.getLayout()).marginWidth = 0;
        this.fOverViewButton = this.createButton(c, 32, JavadocExportMessages.JavadocSpecificsWizardPage_overviewbutton_label, this.createGridData(1));
        this.fOverViewText = this.createText(c, 2052, null, this.createGridData(768, 1, 0));
        ((GridData)this.fOverViewText.getLayoutData()).widthHint = 200;
        this.fOverViewBrowseButton = this.createButton(c, 8, JavadocExportMessages.JavadocSpecificsWizardPage_overviewbrowse_label, this.createGridData(128, 1, 0));
        SWTUtil.setButtonDimensionHint(this.fOverViewBrowseButton);
        String str = this.fStore.getOverview();
        if (str.length() == 0) {
            this.fOverViewText.setEnabled(false);
            this.fOverViewBrowseButton.setEnabled(false);
        } else {
            this.fOverViewButton.setSelection(true);
            this.fOverViewText.setText(str);
        }
        this.createLabel(composite, 0, JavadocExportMessages.JavadocSpecificsWizardPage_vmoptionsfield_label, this.createGridData(32, 3, 0));
        this.fVMOptionsText = this.createText(composite, 2052, null, this.createGridData(256, 3, 0));
        this.fVMOptionsText.setText(this.fStore.getVMParams());
        this.createLabel(composite, 0, JavadocExportMessages.JavadocSpecificsWizardPage_extraoptionsfield_label, this.createGridData(32, 3, 0));
        this.fExtraOptionsText = this.createText(composite, 2882, null, this.createGridData(1296, 3, 0));
        this.fExtraOptionsText.setText(this.fStore.getAdditionalParams());
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(4, 1, false, false, 3, 1));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        this.fOverViewButton.addSelectionListener((SelectionListener)new JavadocWizardPage.ToggleSelectionAdapter(new Control[]{this.fOverViewBrowseButton, this.fOverViewText}){

            @Override
            public void validate() {
                JavadocSpecificsWizardPage.this.doValidation(1);
            }
        });
        this.fOverViewText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavadocSpecificsWizardPage.this.doValidation(1);
            }
        });
        this.fOverViewBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JavadocSpecificsWizardPage.this.handleFileBrowseButtonPressed(JavadocSpecificsWizardPage.this.fOverViewText, new String[]{"*.html"}, JavadocExportMessages.JavadocSpecificsWizardPage_overviewbrowsedialog_title);
            }
        });
    }

    private void createAntGroup(Composite composite) {
        Composite c = new Composite(composite, 0);
        c.setLayout((Layout)this.createGridLayout(3));
        c.setLayoutData((Object)this.createGridData(768, 3, 0));
        ((GridLayout)c.getLayout()).marginWidth = 0;
        this.fAntButton = this.createButton(c, 32, JavadocExportMessages.JavadocSpecificsWizardPage_antscriptbutton_label, this.createGridData(3));
        this.createLabel(c, 0, JavadocExportMessages.JavadocSpecificsWizardPage_antscripttext_label, this.createGridData(32, 1, 0));
        this.fAntText = this.createText(c, 2052, null, this.createGridData(768, 1, 0));
        ((GridData)this.fAntText.getLayoutData()).widthHint = 200;
        this.fAntText.setText(this.fStore.getAntpath());
        this.fAntBrowseButton = this.createButton(c, 8, JavadocExportMessages.JavadocSpecificsWizardPage_antscriptbrowse_label, this.createGridData(128, 1, 0));
        SWTUtil.setButtonDimensionHint(this.fAntBrowseButton);
        this.fAntText.setEnabled(false);
        this.fAntBrowseButton.setEnabled(false);
        this.fCheckbrowser = this.createButton(c, 32, JavadocExportMessages.JavadocSpecificsWizardPage_openbrowserbutton_label, this.createGridData(3));
        this.fCheckbrowser.setSelection(this.fStore.doOpenInBrowser());
        this.fAntButton.addSelectionListener((SelectionListener)new JavadocWizardPage.ToggleSelectionAdapter(new Control[]{this.fAntText, this.fAntBrowseButton}){

            @Override
            public void validate() {
                JavadocSpecificsWizardPage.this.doValidation(2);
            }
        });
        this.fAntText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavadocSpecificsWizardPage.this.doValidation(2);
            }
        });
        this.fAntBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String temp = JavadocSpecificsWizardPage.this.fAntText.getText();
                IPath path = Path.fromOSString((String)temp);
                String file = path.lastSegment();
                if (file == null) {
                    file = "javadoc.xml";
                }
                path = path.removeLastSegments(1);
                String selected = JavadocSpecificsWizardPage.this.handleFolderBrowseButtonPressed(path.toOSString(), JavadocExportMessages.JavadocSpecificsWizardPage_antscriptbrowsedialog_title, JavadocExportMessages.JavadocSpecificsWizardPage_antscriptbrowsedialog_label);
                path = Path.fromOSString((String)selected).append(file);
                JavadocSpecificsWizardPage.this.fAntText.setText(path.toOSString());
            }
        });
    }

    private void doValidation(int val) {
        switch (val) {
            case 1: {
                this.fOverviewStatus = new StatusInfo();
                if (!this.fOverViewButton.getSelection()) break;
                String filename = this.fOverViewText.getText();
                if (filename.length() == 0) {
                    this.fOverviewStatus.setError(JavadocExportMessages.JavadocSpecificsWizardPage_overviewnotfound_error);
                    break;
                }
                File file = new File(filename);
                String ext = filename.substring(filename.lastIndexOf(46) + 1);
                if (!file.isFile()) {
                    this.fOverviewStatus.setError(JavadocExportMessages.JavadocSpecificsWizardPage_overviewnotfound_error);
                    break;
                }
                if (ext.equalsIgnoreCase("html")) break;
                this.fOverviewStatus.setError(JavadocExportMessages.JavadocSpecificsWizardPage_overviewincorrect_error);
                break;
            }
            case 2: {
                this.fAntStatus = new StatusInfo();
                if (!this.fAntButton.getSelection()) break;
                String filename = this.fAntText.getText();
                if (filename.length() == 0) {
                    this.fOverviewStatus.setError(JavadocExportMessages.JavadocSpecificsWizardPage_antfileincorrect_error);
                    break;
                }
                File file = new File(filename);
                String ext = filename.substring(filename.lastIndexOf(46) + 1);
                if (file.isDirectory() || !ext.equalsIgnoreCase("xml")) {
                    this.fAntStatus.setError(JavadocExportMessages.JavadocSpecificsWizardPage_antfileincorrect_error);
                    break;
                }
                if (!file.exists()) break;
                this.fAntStatus.setWarning(JavadocExportMessages.JavadocSpecificsWizardPage_antfileoverwrite_warning);
            }
        }
        this.updateStatus(this.findMostSevereStatus());
    }

    protected void updateStore() {
        this.fStore.setVMParams(this.fVMOptionsText.getText());
        this.fStore.setAdditionalParams(this.fExtraOptionsText.getText());
        if (this.fOverViewText.getEnabled()) {
            this.fStore.setOverview(this.fOverViewText.getText());
        } else {
            this.fStore.setOverview("");
        }
        if (this.fAntText.getEnabled()) {
            this.fStore.setGeneralAntpath(this.fAntText.getText());
        }
        this.fStore.setOpenInBrowser(this.fCheckbrowser.getSelection());
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.doValidation(1);
            this.doValidation(2);
            this.fCheckbrowser.setVisible(!this.fFirstPage.getCustom());
        }
    }

    public void init() {
        this.updateStatus(new StatusInfo());
    }

    private IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere(new IStatus[]{this.fAntStatus, this.fOverviewStatus});
    }

    public boolean generateAnt() {
        return this.fAntButton.getSelection();
    }
}

