/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.jdt.ui;

import java.lang.reflect.Method;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.Messages;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.jdt.core.SubtypesScope;
import org.eclipse.wb.internal.core.utils.jdt.ui.PreferencesAdapter;
import org.osgi.framework.Bundle;

public final class JdtUiUtils {
    private static IPreferenceStore m_combinedPreferenceStore;
    private static JavaTextTools m_javaTextTools;
    private static AbstractUIPlugin m_javaPlugin;

    public static void setJavaSourceForViewer(SourceViewer viewer, String source) {
        Document doc = new Document(source);
        JdtUiUtils.getJavaTextTools().setupJavaDocumentPartitioner((IDocument)doc);
        viewer.setInput((Object)doc);
    }

    public static SourceViewer createJavaSourceViewer(Composite parent, int style) {
        SourceViewer viewer = null;
        IPreferenceStore store = JdtUiUtils.getCombinedPreferenceStore();
        viewer = new SourceViewer(parent, null, style);
        IColorManager colorManager = JdtUiUtils.getJavaTextTools().getColorManager();
        viewer.configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(colorManager, store, null, null));
        viewer.setEditable(false);
        return viewer;
    }

    private static AbstractUIPlugin getJavaPlugin() {
        if (m_javaPlugin == null) {
            m_javaPlugin = (AbstractUIPlugin)ExecutionUtils.runObject(() -> JdtUiUtils.getJavaPlugin0());
        }
        return m_javaPlugin;
    }

    private static AbstractUIPlugin getJavaPlugin0() throws Exception {
        return JdtUiUtils.getBundleActivator("org.eclipse.jdt.ui");
    }

    private static IPreferenceStore getCombinedPreferenceStore() {
        if (m_combinedPreferenceStore == null) {
            IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
            m_combinedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{JdtUiUtils.getJavaPlugin().getPreferenceStore(), new PreferencesAdapter(JavaCore.getPlugin().getPluginPreferences()), generalTextStore});
        }
        return m_combinedPreferenceStore;
    }

    private static JavaTextTools getJavaTextTools() {
        if (m_javaTextTools == null) {
            m_javaTextTools = new JavaTextTools(JdtUiUtils.getJavaPlugin().getPreferenceStore(), JavaCore.getPlugin().getPluginPreferences());
        }
        return m_javaTextTools;
    }

    public static IType selectSubType(Shell shell, IJavaProject javaProject, String superTypeName) {
        return (IType)ExecutionUtils.runObjectLog(() -> {
            IType actionType = javaProject.findType(superTypeName);
            SubtypesScope scope = new SubtypesScope(actionType);
            return JdtUiUtils.selectType(DesignerPlugin.getShell(), scope);
        }, null);
    }

    public static IType selectType(Shell shell, IJavaProject javaProject) throws Exception {
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{javaProject});
        return JdtUiUtils.selectType(shell, scope, 256);
    }

    public static IType selectClassType(Shell shell, IJavaProject javaProject) throws Exception {
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{javaProject});
        return JdtUiUtils.selectType(shell, scope);
    }

    public static IType selectType(Shell shell, IJavaSearchScope scope) throws Exception {
        return JdtUiUtils.selectType(shell, scope, 2);
    }

    public static IType selectType(Shell shell, IJavaSearchScope scope, int style) throws Exception {
        ProgressMonitorDialog context = new ProgressMonitorDialog(shell);
        SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)context, (IJavaSearchScope)scope, (int)style, (boolean)false);
        dialog.setTitle(Messages.JdtUiUtils_selectTypeTitle);
        dialog.setMessage(Messages.JdtUiUtils_selectTypeMessage);
        if (dialog.open() == 0) {
            return (IType)dialog.getResult()[0];
        }
        return null;
    }

    public static String selectTypeName(Shell shell, IJavaProject javaProject) throws Exception {
        IType type = JdtUiUtils.selectClassType(shell, javaProject);
        return type != null ? type.getFullyQualifiedName() : null;
    }

    public static AbstractUIPlugin getBundleActivator(String bundleName) throws Exception {
        Bundle bundle = Platform.getBundle((String)bundleName);
        String pluginActivatorClassName = (String)bundle.getHeaders().get("Bundle-Activator");
        Class pluginClass = bundle.loadClass(pluginActivatorClassName);
        Method getDefaultMethod = pluginClass.getMethod("getDefault", new Class[0]);
        return (AbstractUIPlugin)getDefaultMethod.invoke(null, new Object[0]);
    }
}

