/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.part;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.core.gef.policy.selection.LineSelectionEditPolicy;
import org.eclipse.wb.core.model.IWrapper;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;

public class AbstractWrapperEditPart
extends GraphicalEditPart {
    private final IWrapper m_wrapper;

    public AbstractWrapperEditPart(IWrapper wrapper) {
        this.setModel((Object)wrapper.getWrapperInfo());
        this.m_wrapper = wrapper;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new LineSelectionEditPolicy(ColorConstants.black));
    }

    protected Figure createFigure() {
        return new Figure(){

            protected void paintClientArea(Graphics graphics) {
                ImageDescriptor imageDescriptor = AbstractWrapperEditPart.this.m_wrapper.getWrapperInfo().getDescription().getIcon();
                if (imageDescriptor != null) {
                    Image image = imageDescriptor.createImage();
                    graphics.drawImage(image, 0, 0);
                    image.dispose();
                }
            }
        };
    }

    protected void refreshVisuals() {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                AbstractWrapperEditPart.this.refreshVisuals0();
            }
        });
    }

    private void refreshVisuals0() {
        ImageData imageData = this.m_wrapper.getWrapperInfo().getDescription().getIcon().getImageData(100);
        int width = imageData.width;
        int height = imageData.height;
        Rectangle parentClientArea = ((GraphicalEditPart)this.getParent()).getFigure().getClientArea();
        Point location = parentClientArea.getBottomRight().getTranslated(-width, -height);
        location.performTranslate(-3, -3);
        Rectangle bounds = new Rectangle(location.x, location.y, width, height);
        this.getFigure().setBounds(bounds);
    }
}

