/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.handler.images;

import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.tcf.te.ui.jface.images.AbstractImageDescriptor;

public class ActionHistoryImageDescriptor
extends AbstractImageDescriptor {
    private Image baseImage;
    private Point imageSize;
    private boolean valid;

    public ActionHistoryImageDescriptor(ImageRegistry registry, Image baseImage, boolean valid) {
        super(registry);
        this.baseImage = baseImage;
        this.imageSize = new Point(baseImage.getImageData().width, baseImage.getImageData().height);
        this.initialize(valid);
        this.defineKey(baseImage.hashCode());
    }

    protected void initialize(boolean valid) {
        this.valid = valid;
    }

    protected void defineKey(int hashCode) {
        String key = "AHID:" + hashCode + ":" + this.valid;
        this.setDecriptorKey(key);
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawCentered(this.baseImage, width, height);
        if (!this.valid) {
            this.drawTopLeft("RedXOverlay");
        }
    }

    protected Point getSize() {
        return this.imageSize;
    }

    protected Image getBaseImage() {
        return this.baseImage;
    }
}

