/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.framework.rules.simple;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swtbot.generator.framework.GenerationSimpleRule;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

public class DoubleClickTableItemRule
extends GenerationSimpleRule {
    private int index;
    private Table table;
    private TableItem currentItem;
    boolean useIndex = false;

    @Override
    public boolean appliesTo(Event event) {
        return event.widget instanceof Table && event.type == 8 && ((Table)event.widget).getSelectionCount() == 1;
    }

    @Override
    public void initializeForEvent(Event event) {
        TableItem[] tableitems;
        this.table = (Table)event.widget;
        this.currentItem = (TableItem)event.item;
        this.index = WidgetUtils.getIndex((Control)this.table);
        this.currentItem = this.table.getSelection()[0];
        int nbOccurrences = 0;
        TableItem[] tableItemArray = tableitems = this.table.getItems();
        int n = tableitems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getText().equals(this.currentItem.getText()) && ++nbOccurrences > 1) {
                this.useIndex = true;
                break;
            }
            ++n2;
        }
    }

    public String getWidgetAccessor() {
        StringBuilder res = new StringBuilder();
        res.append("bot.table(");
        if (this.index != 0) {
            res.append(this.index);
        }
        res.append(")");
        res.append(".getTableItem(");
        if (this.useIndex) {
            res.append(this.table.indexOf(this.currentItem));
        } else {
            res.append("\"" + this.currentItem.getText() + "\"");
        }
        res.append(")");
        return res.toString();
    }

    public Table getWidget() {
        return this.table;
    }

    @Override
    public List<String> getActions() {
        ArrayList<String> actions = new ArrayList<String>();
        StringBuilder code = new StringBuilder();
        code.append(this.getWidgetAccessor());
        code.append(".doubleClick()");
        actions.add(code.toString());
        return actions;
    }

    @Override
    public List<String> getImports() {
        return null;
    }
}

