/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.cli;

import java.util.List;
import java.util.Optional;
import org.eclipse.passage.lic.cli.Interaction;
import org.eclipse.passage.lic.cli.Option;

final class Options<D extends Enum<?>> {
    private final List<Option<D>> options;
    private final Interaction interaction;

    Options(Interaction interaction, List<Option<D>> options) {
        this.options = options;
        this.interaction = interaction;
    }

    Option<D> promptAndPick() {
        while (true) {
            this.options.forEach(option -> this.interaction.prompt(option.documentation()));
            String key = this.interaction.input().trim();
            Optional<Option<D>> option2 = this.findOption(key);
            if (option2.isPresent()) {
                return option2.get();
            }
            this.interaction.prompt(String.format("No option has been found for key [%s]", key));
        }
    }

    private Optional<Option<D>> findOption(String request) {
        if (request.length() != 1) {
            return Optional.empty();
        }
        char key = request.charAt(0);
        return this.options.stream().filter(op -> op.key() == key).findAny();
    }
}

