/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.command;

import org.eclipse.jst.jsf.facesconfig.ui.pageflow.command.ConnectionCommand;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.layout.PageflowLayoutManager;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.Pageflow;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.util.PageflowValidation;

public class AddConnectionCommand
extends ConnectionCommand {
    @Override
    public boolean canExecute() {
        if (this.link == null) {
            return false;
        }
        if (this.oldSource == null && this.oldTarget == null) {
            if (this.source == null || this.target == null) {
                return false;
            }
            if (!PageflowValidation.getInstance().isValidLinkForCreation(this.source, this.target)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void doExecute() {
        if (this.canExecute() && this.oldSource == null && this.oldTarget == null) {
            Pageflow pageflow = null;
            if (this.source != null) {
                pageflow = this.source.getPageflow();
            } else if (this.target != null) {
                pageflow = this.target.getPageflow();
            }
            pageflow.connect(this.source, this.target, this.link);
            if (this.source == this.target) {
                PageflowLayoutManager.updateSelfLoopLink(this.link);
            }
        }
    }

    @Override
    public void redo() {
        super.redo();
    }

    @Override
    public void undo() {
        if (this.canExecute() && this.oldSource == null && this.oldTarget == null) {
            Pageflow pageflow = null;
            if (this.source != null) {
                pageflow = this.source.getPageflow();
            } else if (this.target != null) {
                pageflow = this.target.getPageflow();
            }
            this.link.setSource(null);
            this.link.setTarget(null);
            pageflow.getLinks().remove((Object)this.link);
        }
    }
}

