/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.swt.bindings;

import org.eclipse.jpt.common.ui.internal.swt.events.DisposeAdapter;
import org.eclipse.jpt.common.ui.internal.swt.events.ModifyAdapter;
import org.eclipse.jpt.common.ui.internal.swt.listeners.SWTListenerTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

final class TextFieldModelBinding {
    private final ModifiablePropertyValueModel<String> textModel;
    private final PropertyChangeListener textListener;
    private final Text textField;
    private final ModifyListener textFieldModifyListener;
    private final DisposeListener textFieldDisposeListener;

    TextFieldModelBinding(ModifiablePropertyValueModel<String> textModel, Text textField) {
        if (textModel == null || textField == null) {
            throw new NullPointerException();
        }
        this.textModel = textModel;
        this.textField = textField;
        this.textListener = this.buildTextListener();
        this.textModel.addPropertyChangeListener("value", this.textListener);
        this.textFieldModifyListener = this.buildTextFieldModifyListener();
        this.textField.addModifyListener(this.textFieldModifyListener);
        this.textFieldDisposeListener = this.buildTextFieldDisposeListener();
        this.textField.addDisposeListener(this.textFieldDisposeListener);
        this.setTextFieldText((String)textModel.getValue());
    }

    private PropertyChangeListener buildTextListener() {
        return SWTListenerTools.wrap((PropertyChangeListener)new TextListener(), (Widget)this.textField);
    }

    private ModifyListener buildTextFieldModifyListener() {
        return new TextFieldModifyListener();
    }

    private DisposeListener buildTextFieldDisposeListener() {
        return new TextFieldDisposeListener();
    }

    void textChanged(PropertyChangeEvent event) {
        if (!this.textField.isDisposed()) {
            this.setTextFieldText((String)event.getNewValue());
        }
    }

    private void setTextFieldText(String text) {
        this.setTextFieldText_(text == null ? "" : text);
    }

    private void setTextFieldText_(String text) {
        if (!text.equals(this.textField.getText())) {
            this.textField.setText(text);
        }
    }

    void textFieldModified() {
        this.textModel.setValue((Object)this.textField.getText());
    }

    void textFieldDisposed() {
        this.textField.removeDisposeListener(this.textFieldDisposeListener);
        this.textField.removeModifyListener(this.textFieldModifyListener);
        this.textModel.removePropertyChangeListener("value", this.textListener);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.textModel);
    }

    class TextFieldDisposeListener
    extends DisposeAdapter {
        TextFieldDisposeListener() {
        }

        @Override
        public void widgetDisposed(DisposeEvent event) {
            TextFieldModelBinding.this.textFieldDisposed();
        }
    }

    class TextFieldModifyListener
    extends ModifyAdapter {
        TextFieldModifyListener() {
        }

        @Override
        public void modifyText(ModifyEvent event) {
            TextFieldModelBinding.this.textFieldModified();
        }
    }

    class TextListener
    extends PropertyChangeAdapter {
        TextListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            TextFieldModelBinding.this.textChanged(event);
        }
    }
}

