/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.memory.transport;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.eclipse.cdt.debug.core.memory.transport.ExportRequest;
import org.eclipse.cdt.debug.core.memory.transport.FileExport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.MemoryByte;

public final class PlainTextExport
extends FileExport {
    public PlainTextExport(File output, ExportRequest request) {
        super(output, request);
    }

    @Override
    protected BigInteger chunkSize() {
        BigInteger dataCellSize = BigInteger.valueOf(1L);
        BigInteger numberOfColumns = BigInteger.valueOf(32L).divide(this.addressable);
        return dataCellSize.multiply(numberOfColumns);
    }

    @Override
    protected void transfer(OutputStream output, BigInteger factor, IProgressMonitor monitor) throws IOException, DebugException {
        BigInteger dataCellSize = BigInteger.valueOf(1L);
        BigInteger transferAddress = this.start;
        BigInteger jobCount = BigInteger.ZERO;
        BigInteger dataCellsPerLine = this.chunkSize();
        while (transferAddress.compareTo(this.end) < 0 && !monitor.isCanceled()) {
            BigInteger length = dataCellsPerLine;
            if (this.end.subtract(transferAddress).compareTo(length) < 0) {
                length = this.end.subtract(transferAddress);
            }
            monitor.subTask(this.transferring(length, transferAddress));
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < length.divide(dataCellSize).intValue()) {
                if (i != 0) {
                    buf.append(" ");
                }
                BigInteger from = transferAddress.add(dataCellSize.multiply(BigInteger.valueOf(i)));
                MemoryByte[] bytes = this.read.from(from, dataCellSize.longValue());
                int byteIndex = 0;
                while (byteIndex < bytes.length) {
                    String bString = BigInteger.valueOf(0xFF & bytes[byteIndex].getValue()).toString(16);
                    if (bString.length() == 1) {
                        buf.append("0");
                    }
                    buf.append(bString);
                    ++byteIndex;
                }
                ++i;
            }
            output.write(buf.toString().toUpperCase().getBytes());
            output.write("\n".getBytes());
            transferAddress = transferAddress.add(length);
            jobCount = jobCount.add(BigInteger.ONE);
            if (jobCount.compareTo(factor) != 0) continue;
            jobCount = BigInteger.ZERO;
            monitor.worked(1);
        }
    }
}

