/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.CaConfig;
import org.mandas.docker.client.messages.swarm.DispatcherConfig;
import org.mandas.docker.client.messages.swarm.EncryptionConfig;
import org.mandas.docker.client.messages.swarm.OrchestrationConfig;
import org.mandas.docker.client.messages.swarm.RaftConfig;
import org.mandas.docker.client.messages.swarm.SwarmSpec;
import org.mandas.docker.client.messages.swarm.TaskDefaults;

final class ImmutableSwarmSpec
implements SwarmSpec {
    @Nullable
    private final String name;
    @Nullable
    private final Map<String, String> labels;
    @Nullable
    private final OrchestrationConfig orchestration;
    @Nullable
    private final RaftConfig raft;
    @Nullable
    private final DispatcherConfig dispatcher;
    @Nullable
    private final CaConfig caConfig;
    @Nullable
    private final EncryptionConfig encryptionConfig;
    @Nullable
    private final TaskDefaults taskDefaults;

    private ImmutableSwarmSpec(@Nullable String name, @Nullable Map<String, String> labels, @Nullable OrchestrationConfig orchestration, @Nullable RaftConfig raft, @Nullable DispatcherConfig dispatcher, @Nullable CaConfig caConfig, @Nullable EncryptionConfig encryptionConfig, @Nullable TaskDefaults taskDefaults) {
        this.name = name;
        this.labels = labels;
        this.orchestration = orchestration;
        this.raft = raft;
        this.dispatcher = dispatcher;
        this.caConfig = caConfig;
        this.encryptionConfig = encryptionConfig;
        this.taskDefaults = taskDefaults;
    }

    @Override
    @JsonProperty(value="Name")
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Labels")
    @Nullable
    public Map<String, String> labels() {
        return this.labels;
    }

    @Override
    @JsonProperty(value="Orchestration")
    @Nullable
    public OrchestrationConfig orchestration() {
        return this.orchestration;
    }

    @Override
    @JsonProperty(value="Raft")
    @Nullable
    public RaftConfig raft() {
        return this.raft;
    }

    @Override
    @JsonProperty(value="Dispatcher")
    @Nullable
    public DispatcherConfig dispatcher() {
        return this.dispatcher;
    }

    @Override
    @JsonProperty(value="CAConfig")
    @Nullable
    public CaConfig caConfig() {
        return this.caConfig;
    }

    @Override
    @JsonProperty(value="EncryptionConfig")
    @Nullable
    public EncryptionConfig encryptionConfig() {
        return this.encryptionConfig;
    }

    @Override
    @JsonProperty(value="TaskDefaults")
    @Nullable
    public TaskDefaults taskDefaults() {
        return this.taskDefaults;
    }

    public final ImmutableSwarmSpec withName(@Nullable String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableSwarmSpec(value, this.labels, this.orchestration, this.raft, this.dispatcher, this.caConfig, this.encryptionConfig, this.taskDefaults);
    }

    public final ImmutableSwarmSpec withLabels(@Nullable Map<String, ? extends String> entries) {
        if (this.labels == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableSwarmSpec.createUnmodifiableMap(true, false, entries);
        return new ImmutableSwarmSpec(this.name, newValue, this.orchestration, this.raft, this.dispatcher, this.caConfig, this.encryptionConfig, this.taskDefaults);
    }

    public final ImmutableSwarmSpec withOrchestration(@Nullable OrchestrationConfig value) {
        if (this.orchestration == value) {
            return this;
        }
        return new ImmutableSwarmSpec(this.name, this.labels, value, this.raft, this.dispatcher, this.caConfig, this.encryptionConfig, this.taskDefaults);
    }

    public final ImmutableSwarmSpec withRaft(@Nullable RaftConfig value) {
        if (this.raft == value) {
            return this;
        }
        return new ImmutableSwarmSpec(this.name, this.labels, this.orchestration, value, this.dispatcher, this.caConfig, this.encryptionConfig, this.taskDefaults);
    }

    public final ImmutableSwarmSpec withDispatcher(@Nullable DispatcherConfig value) {
        if (this.dispatcher == value) {
            return this;
        }
        return new ImmutableSwarmSpec(this.name, this.labels, this.orchestration, this.raft, value, this.caConfig, this.encryptionConfig, this.taskDefaults);
    }

    public final ImmutableSwarmSpec withCaConfig(@Nullable CaConfig value) {
        if (this.caConfig == value) {
            return this;
        }
        return new ImmutableSwarmSpec(this.name, this.labels, this.orchestration, this.raft, this.dispatcher, value, this.encryptionConfig, this.taskDefaults);
    }

    public final ImmutableSwarmSpec withEncryptionConfig(@Nullable EncryptionConfig value) {
        if (this.encryptionConfig == value) {
            return this;
        }
        return new ImmutableSwarmSpec(this.name, this.labels, this.orchestration, this.raft, this.dispatcher, this.caConfig, value, this.taskDefaults);
    }

    public final ImmutableSwarmSpec withTaskDefaults(@Nullable TaskDefaults value) {
        if (this.taskDefaults == value) {
            return this;
        }
        return new ImmutableSwarmSpec(this.name, this.labels, this.orchestration, this.raft, this.dispatcher, this.caConfig, this.encryptionConfig, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSwarmSpec && this.equalTo(0, (ImmutableSwarmSpec)another);
    }

    private boolean equalTo(int synthetic, ImmutableSwarmSpec another) {
        return Objects.equals(this.name, another.name) && Objects.equals(this.labels, another.labels) && Objects.equals(this.orchestration, another.orchestration) && Objects.equals(this.raft, another.raft) && Objects.equals(this.dispatcher, another.dispatcher) && Objects.equals(this.caConfig, another.caConfig) && Objects.equals(this.encryptionConfig, another.encryptionConfig) && Objects.equals(this.taskDefaults, another.taskDefaults);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.labels);
        h += (h << 5) + Objects.hashCode(this.orchestration);
        h += (h << 5) + Objects.hashCode(this.raft);
        h += (h << 5) + Objects.hashCode(this.dispatcher);
        h += (h << 5) + Objects.hashCode(this.caConfig);
        h += (h << 5) + Objects.hashCode(this.encryptionConfig);
        h += (h << 5) + Objects.hashCode(this.taskDefaults);
        return h;
    }

    public String toString() {
        return "SwarmSpec{name=" + this.name + ", labels=" + this.labels + ", orchestration=" + this.orchestration + ", raft=" + this.raft + ", dispatcher=" + this.dispatcher + ", caConfig=" + this.caConfig + ", encryptionConfig=" + this.encryptionConfig + ", taskDefaults=" + this.taskDefaults + "}";
    }

    public static ImmutableSwarmSpec copyOf(SwarmSpec instance) {
        if (instance instanceof ImmutableSwarmSpec) {
            return (ImmutableSwarmSpec)instance;
        }
        return ImmutableSwarmSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Builder
    implements SwarmSpec.Builder {
        private String name;
        private Map<String, String> labels = null;
        private OrchestrationConfig orchestration;
        private RaftConfig raft;
        private DispatcherConfig dispatcher;
        private CaConfig caConfig;
        private EncryptionConfig encryptionConfig;
        private TaskDefaults taskDefaults;

        private Builder() {
        }

        public final Builder from(SwarmSpec instance) {
            TaskDefaults taskDefaultsValue;
            EncryptionConfig encryptionConfigValue;
            CaConfig caConfigValue;
            DispatcherConfig dispatcherValue;
            RaftConfig raftValue;
            OrchestrationConfig orchestrationValue;
            Map<String, String> labelsValue;
            Objects.requireNonNull(instance, "instance");
            String nameValue = instance.name();
            if (nameValue != null) {
                this.name(nameValue);
            }
            if ((labelsValue = instance.labels()) != null) {
                this.putAllLabels(labelsValue);
            }
            if ((orchestrationValue = instance.orchestration()) != null) {
                this.orchestration(orchestrationValue);
            }
            if ((raftValue = instance.raft()) != null) {
                this.raft(raftValue);
            }
            if ((dispatcherValue = instance.dispatcher()) != null) {
                this.dispatcher(dispatcherValue);
            }
            if ((caConfigValue = instance.caConfig()) != null) {
                this.caConfig(caConfigValue);
            }
            if ((encryptionConfigValue = instance.encryptionConfig()) != null) {
                this.encryptionConfig(encryptionConfigValue);
            }
            if ((taskDefaultsValue = instance.taskDefaults()) != null) {
                this.taskDefaults(taskDefaultsValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Name")
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public final Builder addLabel(String key, String value) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            this.labels.put(Objects.requireNonNull(key, "labels key"), Objects.requireNonNull(value, value == null ? "labels value for key: " + key : null));
            return this;
        }

        public final Builder addLabel(Map.Entry<String, ? extends String> entry) {
            String v;
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "labels value for key: " + k : null));
            return this;
        }

        @Override
        @JsonProperty(value="Labels")
        public final Builder labels(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.labels = null;
                return this;
            }
            this.labels = new LinkedHashMap<String, String>();
            return this.putAllLabels(entries);
        }

        public final Builder putAllLabels(Map<String, ? extends String> entries) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "labels value for key: " + k : null));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Orchestration")
        public final Builder orchestration(@Nullable OrchestrationConfig orchestration) {
            this.orchestration = orchestration;
            return this;
        }

        @Override
        @JsonProperty(value="Raft")
        public final Builder raft(@Nullable RaftConfig raft) {
            this.raft = raft;
            return this;
        }

        @Override
        @JsonProperty(value="Dispatcher")
        public final Builder dispatcher(@Nullable DispatcherConfig dispatcher) {
            this.dispatcher = dispatcher;
            return this;
        }

        @Override
        @JsonProperty(value="CAConfig")
        public final Builder caConfig(@Nullable CaConfig caConfig) {
            this.caConfig = caConfig;
            return this;
        }

        @Override
        @JsonProperty(value="EncryptionConfig")
        public final Builder encryptionConfig(@Nullable EncryptionConfig encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        @Override
        @JsonProperty(value="TaskDefaults")
        public final Builder taskDefaults(@Nullable TaskDefaults taskDefaults) {
            this.taskDefaults = taskDefaults;
            return this;
        }

        @Override
        public ImmutableSwarmSpec build() {
            return new ImmutableSwarmSpec(this.name, this.labels == null ? null : ImmutableSwarmSpec.createUnmodifiableMap(false, false, this.labels), this.orchestration, this.raft, this.dispatcher, this.caConfig, this.encryptionConfig, this.taskDefaults);
        }
    }
}

