/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.java6.model;

import javax.swing.LayoutStyle;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.internal.swing.java6.model.SpringInfo;

public final class GapSpringInfo
extends SpringInfo {
    private final boolean m_isContainer;
    private LayoutStyle.ComponentPlacement m_placement;
    private IAbstractComponentInfo m_widget1;
    private IAbstractComponentInfo m_widget2;
    private int m_pref = Integer.MIN_VALUE;
    private int m_max = Integer.MIN_VALUE;

    public GapSpringInfo() {
        this(false);
    }

    public GapSpringInfo(boolean isContainer) {
        this.m_isContainer = isContainer;
    }

    public void setPlacementType(LayoutStyle.ComponentPlacement placement) {
        this.m_placement = placement;
    }

    public void setGapWidgets(IAbstractComponentInfo widget1, IAbstractComponentInfo widget2) {
        this.m_widget1 = widget1;
        this.m_widget2 = widget2;
    }

    public void setPreferredSize(int prefValue) {
        this.m_pref = prefValue;
    }

    public void setMaximumSize(int maxValue) {
        this.m_max = maxValue;
    }

    private boolean isPreferred() {
        return this.m_placement != null;
    }

    private boolean isContainer() {
        return this.m_isContainer;
    }

    @Override
    public void dump(int level, StringBuffer buffer) {
        buffer.append(StringUtils.repeat((String)" ", (int)level));
        if (this.isContainer()) {
            buffer.append("G cont sizes=");
            buffer.append(String.valueOf(this.m_pref == Integer.MIN_VALUE ? "UNSET" : Integer.valueOf(this.m_pref)) + " ");
            buffer.append(this.m_max == Integer.MIN_VALUE ? "UNSET" : Integer.valueOf(this.m_max));
        } else if (this.isPreferred()) {
            buffer.append("G pref=" + String.valueOf((Object)this.m_placement) + " sizes=");
            buffer.append(String.valueOf(this.m_pref == Integer.MIN_VALUE ? "UNSET" : Integer.valueOf(this.m_pref)) + " ");
            buffer.append(this.m_max == Integer.MIN_VALUE ? "UNSET" : Integer.valueOf(this.m_max));
        } else {
            buffer.append("G sizes=");
            super.dump(level, buffer);
        }
        buffer.append("\n");
    }
}

