/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse;

import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.AbstractImageDialog;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.AbstractImagePage;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IHasChildren;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IImageContainer;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IImageElement;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IImageResource;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IImageRoot;

public abstract class AbstractBrowseImagePage
extends AbstractImagePage {
    private final TreeViewer m_viewer;
    private final IImageRoot m_root;

    public AbstractBrowseImagePage(Composite parent, int style, AbstractImageDialog imageDialog, IImageRoot root) {
        super(parent, style, imageDialog);
        this.m_root = root;
        GridLayoutFactory.create((Composite)this);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                AbstractBrowseImagePage.this.m_root.dispose();
            }
        });
        this.m_viewer = new TreeViewer((Composite)this, 2816);
        GridDataFactory.create((Control)this.m_viewer.getTree()).hintC(50, 20).grab().fill();
        this.m_viewer.getTree().setData("org.eclipse.jface.viewers.TreeViewer", (Object)this.m_viewer);
        this.m_viewer.setContentProvider((IContentProvider)new ImageContentProvider());
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new ImageLabelProvider());
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)AbstractBrowseImagePage.this.m_viewer.getSelection();
                if (selection.getFirstElement() instanceof IImageResource) {
                    IImageResource resource = (IImageResource)selection.getFirstElement();
                    AbstractBrowseImagePage.this.m_imageDialog.setResultImageInfo(resource.getImageInfo());
                } else {
                    AbstractBrowseImagePage.this.m_imageDialog.setResultImageInfo(null);
                }
            }
        });
        this.m_viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AbstractBrowseImagePage.this.m_imageDialog.closeOk();
            }
        });
    }

    @Override
    public void activate() {
        this.m_viewer.setInput((Object)this.m_root);
        this.m_imageDialog.setResultImageInfo(null);
    }

    @Override
    public void setInput(Object data) {
        Object[] selectionPath = this.m_root.getSelectionPath(data);
        if (selectionPath != null) {
            this.m_viewer.setExpandedElements(selectionPath);
            this.m_viewer.setSelection((ISelection)new StructuredSelection(selectionPath[selectionPath.length - 1]));
        }
    }

    protected final void refresh() {
        this.m_viewer.refresh();
    }

    protected final TreeViewer getViewer() {
        return this.m_viewer;
    }

    public static boolean isImageExtension(String extension) {
        if (extension == null) {
            return false;
        }
        return extension.equalsIgnoreCase("gif") || extension.equalsIgnoreCase("png") || extension.equalsIgnoreCase("jpg") || extension.equalsIgnoreCase("jpeg") || extension.equalsIgnoreCase("bmp") || extension.equalsIgnoreCase("ico");
    }

    private static final class ImageContentProvider
    implements ITreeContentProvider {
        private ImageContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            try {
                IImageRoot root = (IImageRoot)inputElement;
                return root.elements();
            }
            catch (Throwable throwable) {
                return ArrayUtils.EMPTY_OBJECT_ARRAY;
            }
        }

        /*
         * WARNING - void declaration
         */
        public boolean hasChildren(Object element) {
            Object object = element;
            if (object instanceof IHasChildren) {
                void tester;
                IHasChildren iHasChildren = (IHasChildren)object;
                IHasChildren cfr_ignored_0 = (IHasChildren)object;
                return tester.hasChildren();
            }
            return this.getChildren(element).length != 0;
        }

        /*
         * WARNING - void declaration
         */
        public Object[] getChildren(Object parentElement) {
            try {
                Object object = parentElement;
                if (object instanceof IImageContainer) {
                    void container;
                    IImageContainer iImageContainer = (IImageContainer)object;
                    IImageContainer cfr_ignored_0 = (IImageContainer)object;
                    return container.elements();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }

        public Object getParent(Object element) {
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static final class ImageLabelProvider
    extends LabelProvider {
        private ImageLabelProvider() {
        }

        /*
         * WARNING - void declaration
         */
        public Image getImage(Object element) {
            Object object = element;
            if (object instanceof IImageElement) {
                void imageElement;
                IImageElement iImageElement = (IImageElement)object;
                IImageElement cfr_ignored_0 = (IImageElement)object;
                return imageElement.getImage();
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public String getText(Object element) {
            Object object = element;
            if (object instanceof IImageContainer) {
                void container;
                IImageContainer iImageContainer = (IImageContainer)object;
                IImageContainer cfr_ignored_0 = (IImageContainer)object;
                return container.getName();
            }
            Object object2 = element;
            if (object2 instanceof IImageResource) {
                void resource;
                IImageResource iImageResource = (IImageResource)object2;
                IImageResource cfr_ignored_1 = (IImageResource)object2;
                return resource.getName();
            }
            return "???";
        }
    }
}

