/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.viewers.xychart;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.views.FormatTimeUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.ITimeDataProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public final class TmfXYChartTimeAdapter
implements ITimeDataProvider {
    private final TmfXYChartViewer fTimeProvider;
    private Utils.TimeFormat fTimeFormat;

    public TmfXYChartTimeAdapter(@NonNull TmfXYChartViewer provider) {
        this.fTimeProvider = provider;
    }

    @Override
    public long getBeginTime() {
        return this.fTimeProvider.getStartTime();
    }

    @Override
    public long getEndTime() {
        return this.fTimeProvider.getEndTime();
    }

    @Override
    public long getMinTimeInterval() {
        return 1L;
    }

    @Override
    public int getNameSpace() {
        return 0;
    }

    @Override
    public long getSelectionBegin() {
        return this.fTimeProvider.getSelectionBeginTime();
    }

    @Override
    public long getSelectionEnd() {
        return this.fTimeProvider.getSelectionEndTime();
    }

    @Override
    public long getTime0() {
        return this.fTimeProvider.getWindowStartTime();
    }

    @Override
    public long getTime1() {
        return this.fTimeProvider.getWindowEndTime();
    }

    @Override
    public void setSelectionRangeNotify(long beginTime, long endTime, boolean ensureVisible) {
    }

    @Override
    public void setSelectionRange(long beginTime, long endTime, boolean ensureVisible) {
    }

    @Override
    public long getMinTime() {
        return this.fTimeProvider.getStartTime();
    }

    @Override
    public long getMaxTime() {
        return this.fTimeProvider.getEndTime();
    }

    @Override
    public Utils.TimeFormat getTimeFormat() {
        return this.fTimeFormat;
    }

    @Override
    public int getTimeSpace() {
        return this.getAxisWidth();
    }

    public int getAxisWidth() {
        return this.fTimeProvider.getSwtChart().getPlotArea().getSize().x;
    }

    @Override
    public void setStartFinishTimeNotify(long time0, long time1) {
        this.fTimeProvider.updateWindow(time0, time1);
    }

    @Override
    public void setStartFinishTime(long time0, long time1) {
    }

    @Override
    public void notifyStartFinishTime() {
    }

    @Override
    public void setSelectedTimeNotify(long time, boolean ensureVisible) {
    }

    @Override
    public void setSelectedTime(long time, boolean ensureVisible) {
    }

    @Override
    public void setNameSpace(int width) {
    }

    public void setTimeFormat(FormatTimeUtils.TimeFormat timeFormat) {
        this.fTimeFormat = Utils.TimeFormat.convert(timeFormat);
    }
}

