/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildren;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeLaunch;
import org.eclipse.tcf.util.TCFDataCache;

public class TCFChildrenContextQuery
extends TCFChildren {
    TCFChildrenContextQuery(TCFNode node) {
        super(node);
    }

    @Override
    public void dispose() {
        this.getNodes().clear();
        super.dispose();
    }

    private static String[] getFilterIDs(TCFModel model, Set<String> filter) {
        ILaunchConfiguration launchConfig;
        if (filter != null && (launchConfig = model.getLaunch().getLaunchConfiguration()) != null) {
            HashSet<String> set = new HashSet<String>();
            String launch_name = launchConfig.getName();
            for (String context : filter) {
                int i = context.indexOf(47);
                if (i <= 0 || context.length() <= i + 1 || !launch_name.equals(context.substring(0, i))) continue;
                set.add(context.substring(i + 1));
            }
            return set.toArray(new String[set.size()]);
        }
        return null;
    }

    private static boolean getDescendants(TCFNode node, String[] ids, Descendants res, Runnable done) {
        Map<String, String> map = res.map;
        boolean include_parent = res.include_parent;
        res.map = new HashMap<String, String>();
        TCFModel model = node.getModel();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            assert (!(done instanceof TCFDataCache));
            if (!model.createNode(id, done)) {
                return false;
            }
            TCFNode n3 = model.getNode(id);
            while (n3 != null) {
                if (n3 == node) {
                    res.include_parent = true;
                    break;
                }
                if (n3.parent == node) {
                    res.map.put(id, n3.id);
                    break;
                }
                n3 = n3.parent;
            }
            ++n2;
        }
        if (map != null) {
            res.map.keySet().retainAll(map.keySet());
            res.include_parent = res.include_parent && include_parent;
        }
        return true;
    }

    public static Descendants getDescendants(TCFNode node, String query, Set<String> filter, Runnable done) {
        String[] filter_ids;
        Descendants res = new Descendants();
        String[] query_data = null;
        TCFDataCache query_cache = node.getModel().getLaunch().getContextQuery(query);
        if (query_cache != null) {
            if (!query_cache.validate(done)) {
                return null;
            }
            query_data = (String[])query_cache.getData();
            if (query_data != null && !TCFChildrenContextQuery.getDescendants(node, query_data, res, done)) {
                return null;
            }
        }
        if ((filter_ids = TCFChildrenContextQuery.getFilterIDs(node.getModel(), filter)) != null && !TCFChildrenContextQuery.getDescendants(node, filter_ids, res, done)) {
            return null;
        }
        return res;
    }

    public static Descendants getDescendants(TCFNode node, IViewerUpdate update, Runnable done) {
        IPresentationContext context = update.getPresentationContext();
        String query = (String)context.getProperty("query");
        Set filter = (Set)context.getProperty("contexts");
        return TCFChildrenContextQuery.getDescendants(node, query, filter, done);
    }

    boolean setQuery(IViewerUpdate update, Runnable done) {
        IPresentationContext context = update.getPresentationContext();
        String query = (String)context.getProperty("query");
        Set filter = (Set)context.getProperty("contexts");
        HashMap<String, TCFNode> map = new HashMap<String, TCFNode>();
        TCFChildren cache = null;
        if (this.node instanceof TCFNodeExecContext) {
            cache = ((TCFNodeExecContext)this.node).getChildren();
        } else if (this.node instanceof TCFNodeLaunch) {
            cache = ((TCFNodeLaunch)this.node).getChildren();
        }
        if (cache != null) {
            if (!cache.validate(done)) {
                return false;
            }
            Map cache_data = (Map)cache.getData();
            if (cache_data != null && cache_data.size() > 0) {
                if (query != null || filter != null) {
                    Descendants des = TCFChildrenContextQuery.getDescendants(this.node, query, filter, done);
                    if (des == null) {
                        return false;
                    }
                    for (String id : des.map.values()) {
                        TCFNode n = (TCFNode)cache_data.get(id);
                        if (n == null) continue;
                        map.put(id, n);
                    }
                } else {
                    map.putAll(cache_data);
                }
            }
        }
        this.reset(map);
        return true;
    }

    protected boolean startDataRetrieval() {
        assert (false);
        return true;
    }

    public static class Descendants {
        public Map<String, String> map;
        public boolean include_parent;
    }
}

