/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.tools.internal.command;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.business.api.helper.task.InitInterpreterVariablesTask;
import org.eclipse.sirius.business.api.helper.task.TaskHelper;
import org.eclipse.sirius.business.api.helper.task.label.InitInterpreterFromParsedVariableTask2;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.internal.helper.task.DeleteDRepresentationElementsTask;
import org.eclipse.sirius.business.internal.helper.task.DeleteWithoutToolTask;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.exception.LockedInstanceException;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.business.api.helper.TableVariablesHelper;
import org.eclipse.sirius.table.business.internal.helper.task.CreateTableTask;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTableElement;
import org.eclipse.sirius.table.metamodel.table.DTargetColumn;
import org.eclipse.sirius.table.metamodel.table.LineContainer;
import org.eclipse.sirius.table.metamodel.table.description.CellEditorTool;
import org.eclipse.sirius.table.metamodel.table.description.CellUpdater;
import org.eclipse.sirius.table.metamodel.table.description.ColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.CreateCellTool;
import org.eclipse.sirius.table.metamodel.table.description.CreateTool;
import org.eclipse.sirius.table.metamodel.table.description.DeleteLineTool;
import org.eclipse.sirius.table.metamodel.table.description.DeleteTool;
import org.eclipse.sirius.table.metamodel.table.description.ElementColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.LabelEditTool;
import org.eclipse.sirius.table.metamodel.table.description.TableDescription;
import org.eclipse.sirius.table.metamodel.table.description.TableTool;
import org.eclipse.sirius.table.tools.api.command.ITableCommandFactory;
import org.eclipse.sirius.table.tools.internal.Messages;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.command.AbstractCommandFactory;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.command.InvalidPermissionCommand;
import org.eclipse.sirius.tools.api.command.NoNullResourceCommand;
import org.eclipse.sirius.tools.api.command.SiriusCommand;
import org.eclipse.sirius.tools.api.interpreter.IInterpreterMessages;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.tools.internal.command.builders.ElementsToSelectTask;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.AbstractVariable;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.EditMaskVariables;
import org.eclipse.sirius.viewpoint.description.tool.ModelOperation;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationCreationDescription;

public class TableCommandFactory
extends AbstractCommandFactory
implements ITableCommandFactory {
    private TaskHelper commandTaskHelper;

    public TableCommandFactory(TransactionalEditingDomain domain) {
        super(domain);
    }

    public TableCommandFactory(TransactionalEditingDomain domain, ModelAccessor modelAccessor) {
        super(domain);
    }

    private IPermissionAuthority getPermissionAuthority() {
        return this.modelAccessor.getPermissionAuthority();
    }

    @Override
    public Command buildDeleteTableElement(DTableElement element) {
        UnexecutableCommand cmd = UnexecutableCommand.INSTANCE;
        if (element instanceof DLine || element instanceof DTargetColumn) {
            return this.createAuthorisedCommand((EObject)element, element.eContainer(), () -> {
                SiriusCommand result;
                DeleteTool deleteTool = this.getDeleteTool(element);
                if (deleteTool != null) {
                    result = this.addDeleteTableElementFromTool(element, deleteTool);
                } else {
                    result = new SiriusCommand(this.domain);
                    result.getTasks().add(new DeleteWithoutToolTask((DRepresentationElement)element, this.modelAccessor, this.commandTaskHelper));
                }
                this.addRefreshTask((DSemanticDecorator)TableHelper.getTable((EObject)element), (DCommand)result, (AbstractToolDescription)deleteTool);
                return new NoNullResourceCommand((Command)result, (EObject)element);
            });
        }
        return cmd;
    }

    @Override
    public Command buildCreateLineCommandFromTool(LineContainer lineContainer, CreateTool tool) {
        return this.buildCreateCommandFromTool((DSemanticDecorator)lineContainer, lineContainer.getTarget(), TableVariablesHelper.getVariables((DSemanticDecorator)lineContainer), tool);
    }

    @Override
    public Command buildCreateColumnCommandFromTool(DSemanticDecorator containerView, CreateTool tool) {
        return this.buildCreateCommandFromTool(containerView, containerView.getTarget(), TableVariablesHelper.getVariables(containerView), tool);
    }

    @Override
    @Deprecated
    public Command buildCreateLineCommandFromTool(LineContainer lineContainer, EObject semanticCurrentElement, CreateTool tool) {
        return this.buildCreateCommandFromTool((DSemanticDecorator)lineContainer, semanticCurrentElement, TableCommandFactory.mapOf("root", TableHelper.getTable((EObject)lineContainer).getTarget(), "container", lineContainer.getTarget(), "element", semanticCurrentElement), tool);
    }

    @Override
    @Deprecated
    public Command buildCreateColumnCommandFromTool(DTable containerView, EObject semanticCurrentElement, CreateTool tool) {
        return this.buildCreateCommandFromTool((DSemanticDecorator)containerView, semanticCurrentElement, TableCommandFactory.mapOf("root", containerView.getTarget(), "container", containerView.getTarget(), "element", semanticCurrentElement), tool);
    }

    private <TT extends AbstractToolDescription & TableTool> Command buildCreateCommandFromTool(DSemanticDecorator view, EObject semanticCurrentElement, Map<String, EObject> variables, TT tool) {
        return this.createAuthorisedCommand((EObject)view, () -> {
            SiriusCommand result = this.buildCommandFromTool(TableHelper.getTable((EObject)view), semanticCurrentElement, variables, tool);
            this.addRefreshTask(view, (DCommand)result, tool);
            this.addSelectTask(view, result, tool);
            return result;
        });
    }

    private DeleteTool getDeleteTool(DTableElement element) {
        ColumnMapping columnMapping;
        DeleteLineTool result = null;
        if (element instanceof DLine) {
            result = ((DLine)element).getOriginMapping().getDelete();
        } else if (element instanceof DTargetColumn && (columnMapping = ((DTargetColumn)element).getOriginMapping()) instanceof ElementColumnMapping) {
            result = ((ElementColumnMapping)columnMapping).getDelete();
        }
        return result;
    }

    private SiriusCommand addDeleteTableElementFromTool(DTableElement element, DeleteTool deleteTool) {
        SiriusCommand result = this.buildCommandFromTool((DSemanticDecorator)element, (TableTool)deleteTool);
        result.getTasks().add(new DeleteDRepresentationElementsTask(this.modelAccessor, (DCommand)result, this.commandTaskHelper, (DRepresentationElement)element){

            protected void addDialectSpecificAdditionalDeleteSubTasks(DSemanticDecorator semDec, List<ICommandTask> subTasks) {
                super.addDialectSpecificAdditionalDeleteSubTasks(semDec, subTasks);
                if (semDec instanceof DCell) {
                    DCell cell = (DCell)semDec;
                    subTasks.add((ICommandTask)TableCommandFactory.createTask("", () -> cell.setColumn(null)));
                }
            }
        });
        return result;
    }

    @Deprecated
    protected SiriusCommand buildCommandFromTool(DSemanticDecorator view, TableTool tool) {
        return this.buildCommandFromTool(TableHelper.getTable((EObject)view), view.getTarget(), TableVariablesHelper.getVariables(view), tool);
    }

    protected SiriusCommand buildCommandFromTool(DTable table, EObject semanticCurrentElement, Map<String, EObject> variables, TableTool tool) {
        SiriusCommand result = new SiriusCommand(this.domain);
        this.addInitVariablesTask(result, semanticCurrentElement, TableVariablesHelper.getTableVariables(tool, variables));
        this.addOperationTask(result, (DSemanticDecorator)table, semanticCurrentElement, tool.getFirstModelOperation());
        return result;
    }

    private SiriusCommand buildCommandFromCell(DCell currentCell, TableTool tool, Object newValue) {
        SiriusCommand result = new SiriusCommand(this.domain, Messages.TableCommandFactory_setCellContent);
        EObject interpreterContext = currentCell.getTarget();
        if (interpreterContext == null) {
            interpreterContext = currentCell.getLine().getTarget();
        }
        HashMap<String, EObject> variables = new HashMap<String, EObject>(TableVariablesHelper.getVariables(currentCell));
        EditMaskVariables mask = null;
        if (tool instanceof LabelEditTool) {
            mask = ((LabelEditTool)tool).getMask();
        } else if (tool instanceof CreateCellTool) {
            mask = ((CreateCellTool)tool).getMask();
        } else if (tool instanceof CellEditorTool) {
            variables.put("cellEditorResult", (EObject)newValue);
        }
        this.addInitVariablesTask(result, interpreterContext, TableVariablesHelper.getTableVariables(tool, variables));
        this.addMaskInitTask(result, interpreterContext, mask, newValue);
        this.addOperationTask(result, (DSemanticDecorator)currentCell, interpreterContext, tool.getFirstModelOperation());
        return result;
    }

    private SiriusCommand buildCommandFromIntersection(DLine currentLine, DTargetColumn currentColumn, CreateCellTool tool, Object newValue) {
        SiriusCommand result = new SiriusCommand(this.domain, Messages.TableCommandFactory_setCellContent);
        EObject interpreterContext = currentLine.getTarget();
        Map<String, EObject> variables = TableVariablesHelper.getVariables(currentLine, (DColumn)currentColumn);
        this.addInitVariablesTask(result, interpreterContext, TableVariablesHelper.getTableVariables((TableTool)tool, variables));
        this.addMaskInitTask(result, interpreterContext, tool.getMask(), newValue);
        this.addOperationTask(result, (DSemanticDecorator)currentLine, interpreterContext, tool.getFirstModelOperation());
        return result;
    }

    @Deprecated
    public TaskHelper getCommandTaskHelper() {
        return this.commandTaskHelper;
    }

    private ModelAccessor getModelAccessor() {
        return this.modelAccessor;
    }

    @Override
    public void setModelAccessor(ModelAccessor modelAccessor) {
        this.modelAccessor = modelAccessor;
        this.commandTaskHelper = new TaskHelper(modelAccessor, this.uiCallBack);
    }

    @Override
    public Command buildSetCellValueFromTool(DCell editedCell, Object newValue) {
        CellUpdater updater = editedCell.getUpdater();
        if (updater == null || updater.getDirectEdit() == null && updater.getCellEditor() == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return this.createAuthorisedCommand((EObject)editedCell, () -> {
            Object toolEdit = updater.getCellEditor() != null ? updater.getCellEditor() : updater.getDirectEdit();
            SiriusCommand result = this.buildCommandFromCell(editedCell, (TableTool)toolEdit, newValue);
            this.addRefreshTask((DSemanticDecorator)TableHelper.getTable((EObject)editedCell), (DCommand)result, null);
            return result;
        });
    }

    @Override
    public Command buildCreateCellFromTool(DLine line, DTargetColumn column, Object newValue) {
        return this.createAuthorisedCommand((EObject)line, (EObject)column, () -> {
            Option<CreateCellTool> optionalCreateCellTool = TableHelper.getCreateCellTool(line, (DColumn)column);
            if (!optionalCreateCellTool.some()) {
                return UnexecutableCommand.INSTANCE;
            }
            SiriusCommand result = this.buildCommandFromIntersection(line, column, (CreateCellTool)optionalCreateCellTool.get(), newValue);
            this.addRefreshTask((DSemanticDecorator)TableHelper.getTable((EObject)line), (DCommand)result, (AbstractToolDescription)optionalCreateCellTool.get());
            this.addSelectTask((DSemanticDecorator)line, result, (AbstractToolDescription)optionalCreateCellTool.get());
            return result;
        });
    }

    public DCommand buildCreateTableFromDescription(TableDescription description, EObject semanticElement, IProgressMonitor monitor) {
        SiriusCommand command = new SiriusCommand(this.domain){

            public boolean canUndo() {
                return false;
            }
        };
        command.getTasks().add(new CreateTableTask(description, semanticElement, monitor));
        return command;
    }

    @Override
    public Command buildSetValue(EObject instance, String name, Object value) {
        return this.createAuthorisedCommand(instance, () -> {
            SiriusCommand result = new SiriusCommand(this.domain);
            result.getTasks().add(TableCommandFactory.createTask(MessageFormat.format(Messages.TableCommandFactory_setValue, name), () -> {
                try {
                    if (!this.getModelAccessor().eGet(instance, name).equals(value)) {
                        this.getModelAccessor().eSet(instance, name, value);
                    }
                }
                catch (FeatureNotFoundException e) {
                    SiriusPlugin.getDefault().error(IInterpreterMessages.EVALUATION_ERROR_ON_MODEL_MODIFICATION, (Throwable)e);
                }
            }));
            return result;
        });
    }

    @Override
    public Command buildAddValue(EObject instance, String name, Object value) {
        return this.createAuthorisedCommand(instance, () -> {
            SiriusCommand result = new SiriusCommand(this.domain);
            result.getTasks().add(TableCommandFactory.createTask(MessageFormat.format(Messages.TableCommandFactory_addValue, name), () -> {
                try {
                    this.getModelAccessor().eAdd(instance, name, value);
                }
                catch (FeatureNotFoundException e) {
                    SiriusPlugin.getDefault().error(IInterpreterMessages.EVALUATION_ERROR_ON_MODEL_MODIFICATION, (Throwable)e);
                }
            }));
            return result;
        });
    }

    @Override
    public Command buildClearValue(EObject instance, String name) {
        return this.createAuthorisedCommand(instance, () -> {
            SiriusCommand result = new SiriusCommand(this.domain);
            String label = MessageFormat.format(Messages.TableCommandFactory_clearValue, name);
            result.getTasks().add(TableCommandFactory.createTask(label, () -> this.getModelAccessor().eClear(instance, name)));
            return result;
        });
    }

    public AbstractCommand buildDoExecuteDetailsOperation(DSemanticDecorator target, RepresentationCreationDescription desc, String newRepresentationName) {
        SiriusCommand result = new SiriusCommand(this.domain);
        result.getTasks().add(new InitInterpreterVariablesTask(TableCommandFactory.mapOf(desc.getContainerViewVariable(), target), TableCommandFactory.mapOf(desc.getRepresentationNameVariable(), newRepresentationName), InterpreterUtil.getInterpreter((EObject)target), this.uiCallBack));
        this.addOperationTask(result, target, target.getTarget(), desc.getInitialOperation().getFirstModelOperations());
        return result;
    }

    private Command createAuthorisedCommand(EObject view1, EObject view2, Supplier<Command> factory) {
        Object result = !this.getPermissionAuthority().canEditInstance(view1) ? new InvalidPermissionCommand(this.domain, new EObject[]{view1}) : this.createAuthorisedCommand(view2, factory);
        return result;
    }

    private Command createAuthorisedCommand(EObject view, Supplier<Command> factory) {
        Command result;
        if (!this.getPermissionAuthority().canEditInstance(view)) {
            result = new InvalidPermissionCommand(this.domain, new EObject[]{view});
        } else {
            result = factory.get();
            if (result == null) {
                result = UnexecutableCommand.INSTANCE;
            }
        }
        return result;
    }

    private void addSelectTask(DSemanticDecorator view, SiriusCommand result, AbstractToolDescription tool) {
        Option dRepresentation = new EObjectQuery((EObject)view).getRepresentation();
        result.getTasks().add(new ElementsToSelectTask(tool, InterpreterUtil.getInterpreter((EObject)view.getTarget()), view.getTarget(), (DRepresentation)dRepresentation.get()));
    }

    private void addInitVariablesTask(SiriusCommand result, EObject context, Map<AbstractVariable, Object> variables) {
        result.getTasks().add(new InitInterpreterVariablesTask(variables, InterpreterUtil.getInterpreter((EObject)context), this.uiCallBack));
    }

    private void addMaskInitTask(SiriusCommand result, EObject context, EditMaskVariables mask, Object newValue) {
        if (mask != null && mask.getMask() != null) {
            result.getTasks().add(new InitInterpreterFromParsedVariableTask2(InterpreterUtil.getInterpreter((EObject)context), mask.getMask(), newValue));
        }
    }

    private void addOperationTask(SiriusCommand result, DSemanticDecorator tableElement, EObject context, ModelOperation operation) {
        DTable table = TableHelper.getTable((EObject)tableElement);
        result.getTasks().add(this.commandTaskHelper.buildTaskFromModelOperation((DRepresentation)table, context, operation));
    }

    private static AbstractCommandTask createTask(final String label, final Runnable task) {
        return new AbstractCommandTask(){

            public String getLabel() {
                return label;
            }

            public void execute() {
                try {
                    task.run();
                }
                catch (LockedInstanceException e) {
                    SiriusPlugin.getDefault().error(IInterpreterMessages.EVALUATION_ERROR_ON_MODEL_MODIFICATION, (Throwable)e);
                }
            }
        };
    }

    private static <K, V> Map<K, V> mapOf(K k1, V v1) {
        HashMap<K, V> result = new HashMap<K, V>();
        result.put(k1, v1);
        return Collections.unmodifiableMap(result);
    }

    private static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3) {
        HashMap<K, V> result = new HashMap<K, V>();
        result.put(k1, v1);
        result.put(k2, v2);
        result.put(k3, v3);
        return Collections.unmodifiableMap(result);
    }
}

