/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.color;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.ui.business.api.preferences.SiriusUIPreferencesKeys;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.SystemColors;
import org.eclipse.sirius.viewpoint.description.UserFixedColor;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class ColorManager {
    private static final List<SystemColors> GRAYED_COLORS = Arrays.asList(SystemColors.BLACK_LITERAL, SystemColors.DARK_GRAY_LITERAL, SystemColors.GRAY_LITERAL, SystemColors.LIGHT_GRAY_LITERAL, SystemColors.WHITE_LITERAL);
    private static final List<SystemColors> RAINBOW_COLORS = Arrays.asList(SystemColors.DARK_RED_LITERAL, SystemColors.RED_LITERAL, SystemColors.LIGHT_RED_LITERAL, SystemColors.DARK_CHOCOLATE_LITERAL, SystemColors.CHOCOLATE_LITERAL, SystemColors.LIGHT_CHOCOLATE_LITERAL, SystemColors.DARK_ORANGE_LITERAL, SystemColors.ORANGE_LITERAL, SystemColors.LIGHT_ORANGE_LITERAL, SystemColors.DARK_YELLOW_LITERAL, SystemColors.YELLOW_LITERAL, SystemColors.LIGHT_YELLOW_LITERAL, SystemColors.DARK_GREEN_LITERAL, SystemColors.GREEN_LITERAL, SystemColors.LIGHT_GREEN_LITERAL, SystemColors.DARK_BLUE_LITERAL, SystemColors.BLUE_LITERAL, SystemColors.LIGHT_BLUE_LITERAL, SystemColors.DARK_PURPLE_LITERAL, SystemColors.PURPLE_LITERAL, SystemColors.LIGHT_PURPLE_LITERAL);
    private static final String RGB_VALUES_SEPARATOR = ",";
    private static ColorManager defaultInstance;
    private Map<String, Color> lighterColorCache = new HashMap<String, Color>();

    protected ColorManager() {
    }

    public static ColorManager getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new ColorManager();
        }
        return defaultInstance;
    }

    public Color getLighterColor(RGBValues colorToLight) {
        String key = this.getKey(colorToLight);
        if (!this.lighterColorCache.containsKey(key)) {
            Color newLighterColor = FigureUtilities.mixColors((Color)VisualBindingManager.getDefault().getColorFromRGBValues(colorToLight), (Color)ColorConstants.white, (double)0.4);
            this.lighterColorCache.put(key, newLighterColor);
        }
        return this.lighterColorCache.get(key);
    }

    private String getKey(RGBValues color) {
        StringBuilder sb = new StringBuilder("Color");
        if (color != null) {
            sb.append("_r:");
            sb.append(color.getRed());
            sb.append("_g:");
            sb.append(color.getGreen());
            sb.append("_b:");
            sb.append(color.getBlue());
        }
        return sb.toString();
    }

    public Map<String, RGB> collectVsmAndDefaultColors(Session session) {
        Map vsmColors = new LinkedHashMap();
        IPreferenceStore preferenceStore = SiriusEditPlugin.getPlugin().getPreferenceStore();
        if (preferenceStore != null && preferenceStore.getBoolean(SiriusUIPreferencesKeys.PREF_DISPLAY_VSM_USER_FIXED_COLOR_IN_PALETTE.name())) {
            List palettes = session.getSelectedViewpoints(true).stream().map(EObject::eContainer).map(Group.class::cast).flatMap(group -> group.getUserColorsPalettes().stream()).collect(Collectors.toList());
            vsmColors = palettes.stream().flatMap(palette -> palette.getEntries().stream()).filter(UserFixedColor.class::isInstance).map(UserFixedColor.class::cast).collect(Collectors.toMap(c -> c.getName(), c -> new RGB(c.getRed(), c.getGreen(), c.getBlue()), (rgb1, rgb2) -> rgb1, () -> new LinkedHashMap()));
        }
        Map systemColors = VisualBindingManager.getDefault().getSystemPalette();
        LinkedHashMap<String, RGB> colors = new LinkedHashMap<String, RGB>();
        for (SystemColors color : GRAYED_COLORS) {
            colors.put(color.getName(), (RGB)systemColors.get(color.getName()));
        }
        for (String colorName : vsmColors.keySet()) {
            colors.put(colorName, (RGB)vsmColors.get(colorName));
        }
        for (SystemColors color : RAINBOW_COLORS) {
            colors.put(color.getName(), (RGB)systemColors.get(color.getName()));
        }
        return colors;
    }

    public Map<String, RGB> collectVsmColors(Session session) {
        Map<String, Object> vsmColors = new LinkedHashMap<String, RGB>();
        IPreferenceStore preferenceStore = SiriusEditPlugin.getPlugin().getPreferenceStore();
        if (preferenceStore != null) {
            vsmColors = session.getSelectedViewpoints(true).stream().map(EObject::eContainer).map(Group.class::cast).flatMap(group -> group.getUserColorsPalettes().stream()).flatMap(palette -> palette.getEntries().stream()).filter(UserFixedColor.class::isInstance).map(UserFixedColor.class::cast).collect(Collectors.toMap(c -> c.getName(), c -> new RGB(c.getRed(), c.getGreen(), c.getBlue()), (rgb1, rgb2) -> rgb1, () -> new LinkedHashMap()));
        }
        return vsmColors;
    }

    public String rgbToString(RGB rgb) {
        String result = new String();
        if (rgb != null) {
            result = String.format("{%d, %d, %d}", rgb.red, rgb.green, rgb.blue);
        }
        return result;
    }

    public RGB stringToRGB(String stringToConvert) {
        RGB color = null;
        if (stringToConvert != null && stringToConvert.matches("\\{(\\d{1,3})\\s?,\\s?(\\d{1,3})\\s?,\\s?(\\d{1,3})\\}")) {
            String colorString = stringToConvert.replaceAll(" ", "");
            String[] stringToParseArray = colorString.replaceAll("[{}]", "").split(RGB_VALUES_SEPARATOR);
            try {
                color = new RGB(Integer.parseInt(stringToParseArray[0]), Integer.parseInt(stringToParseArray[1]), Integer.parseInt(stringToParseArray[2]));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DiagramUIPlugin.getPlugin().log(String.format(Messages.ColorManager_logErrorParsingRGB, stringToConvert));
            }
        }
        return color;
    }

    public List<RGB> sortColors(Collection<RGB> colorsToSort) {
        ArrayList<RGB> sortedList = Collections.EMPTY_LIST;
        if (colorsToSort != null) {
            sortedList = new ArrayList<RGB>(colorsToSort);
            Collections.sort(sortedList, new Comparator<RGB>(){

                @Override
                public int compare(RGB o1, RGB o2) {
                    float[] hsb1 = o1.getHSB();
                    float[] hsb2 = o2.getHSB();
                    int hueComparison = Float.compare(hsb1[0], hsb2[0]);
                    int saturationComparison = Float.compare(hsb1[1], hsb2[1]);
                    int brightnessComparison = Float.compare(hsb1[2], hsb2[2]);
                    int result = hueComparison != 0 ? hueComparison : (saturationComparison != 0 ? saturationComparison : brightnessComparison);
                    return result;
                }
            });
        }
        return sortedList;
    }
}

